/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SEOPageMetadataApplicationLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Log LOG = ExoLogger.getLogger((String)SEOPageMetadataApplicationLifecycle.class.toString());

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        String siteName = pcontext.getSiteName();
        try {
            if (pcontext.getSiteType().equals((Object)SiteType.PORTAL)) {
                String pageReference;
                PageMetadataModel metaModel;
                Enumeration params;
                SEOService seoService = (SEOService)CommonsUtils.getService(SEOService.class);
                ArrayList<String> paramArray = null;
                if (!pcontext.useAjax() && (params = pcontext.getRequest().getParameterNames()).hasMoreElements()) {
                    paramArray = new ArrayList<String>();
                    while (params.hasMoreElements()) {
                        String contentParam = (String)params.nextElement();
                        paramArray.add(pcontext.getRequestParameter(contentParam));
                    }
                }
                UserPortal userPortal = pcontext.getUserPortal();
                UserNavigation navigation = userPortal.getNavigation(SiteKey.portal((String)siteName));
                UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
                String nodePath = pcontext.getNodePath();
                UserNode currentNode = null;
                currentNode = StringUtils.isBlank((CharSequence)nodePath) ? userPortal.getDefaultPath(builder.build()) : userPortal.resolvePath(navigation, builder.build(), nodePath);
                if (currentNode != null && currentNode.getPageRef() != null && SiteType.PORTAL.equals((Object)currentNode.getPageRef().getSite().getType()) && (metaModel = seoService.getMetadata(paramArray, pageReference = currentNode.getPageRef().format(), pcontext.getLocale().getLanguage())) != null) {
                    pcontext.setAttribute("PAGE_METADATA", (Object)metaModel);
                    if (StringUtils.isNotBlank((CharSequence)metaModel.getTitle())) {
                        pcontext.getRequest().setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)metaModel.getTitle());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting page SEO of site {} with path {}", new Object[]{siteName, requestPath, e});
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) {
    }
}

