/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.webui.filters;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.DriveRemovedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class CloudDriveFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveFilter.class);

    public CloudDriveFilter() {
    }

    public CloudDriveFilter(List<String> providers) {
        super(providers);
    }

    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        CloudDrive drive = driveService.findDrive(node);
        try {
            return drive != null && this.acceptProvider(drive.getUser().getProvider()) && drive.getPath().equals(node.getPath());
        }
        catch (DriveRemovedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> CloudDriveFilter.accept(" + node.getPath() + ") drive removed " + String.valueOf(drive) + ": " + e.getMessage()));
            }
            return false;
        }
    }
}

