/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.space.customization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;

public class SpaceCustomizationService {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceCustomizationService.class);
    private static final String GROUPS_PATH = "groupsPath";
    private static final String SPACE_GROUP_ID_PREFERENCE = "{spaceGroupId}";
    private static final String SPACE_NEW_HOME_PAGE_TEMPLATE = "custom space";
    private static final String SCV_PORTLEt_NAME = "SingleContentViewer";
    private static final String ACTIVITY_FOLDER_UPLOAD_NAME = "Activity Stream Documents";
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private DMSConfiguration dmsConfiguration = null;
    private RepositoryService repositoryService = null;
    private ConfigurationManager configurationManager = null;
    private DataStorage dataStorageService = null;
    PageService pageService = null;
    private UserPortalConfigService userPortalConfigService = null;
    private SpaceService spaceService = null;
    private SpaceTemplateService spaceTemplateService = null;
    private UserACL userACL = null;
    private String groupsPath;

    public SpaceCustomizationService(DataStorage dataStorageService_, PageService pageService_, UserPortalConfigService userPortalConfigService_, SessionProviderService sessionProviderService_, NodeHierarchyCreator nodeHierarchyCreator_, DMSConfiguration dmsConfiguration_, RepositoryService repositoryService_, ConfigurationManager configurationManager_, UserACL userACL_) {
        this.nodeHierarchyCreator = nodeHierarchyCreator_;
        this.dmsConfiguration = dmsConfiguration_;
        this.repositoryService = repositoryService_;
        this.userACL = userACL_;
        this.configurationManager = configurationManager_;
        this.sessionProviderService = sessionProviderService_;
        this.dataStorageService = dataStorageService_;
        this.pageService = pageService_;
        this.userPortalConfigService = userPortalConfigService_;
        this.groupsPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        if (this.groupsPath.lastIndexOf("/") == this.groupsPath.length() - 1) {
            this.groupsPath = this.groupsPath.substring(0, this.groupsPath.lastIndexOf("/"));
        }
    }

    public void editSpaceDriveViewPermissions(String viewNodeName, String permission) throws RepositoryException {
        DMSRepositoryConfiguration dmsRepoConfig;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to add permission " + permission + " for ECMS view " + viewNodeName));
        }
        String viewsPath = this.nodeHierarchyCreator.getJcrPath("userViewsPath");
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = manageableRepository.getSystemSession((dmsRepoConfig = this.dmsConfiguration.getConfig()).getSystemWorkspace());
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        if (viewHomeNode.hasNode(viewNodeName)) {
            Node contentNode = viewHomeNode.getNode(viewNodeName);
            String contentNodePermissions = contentNode.getProperty("exo:accessPermissions").getString();
            contentNode.setProperty("exo:accessPermissions", contentNodePermissions.concat(",").concat(permission));
            viewHomeNode.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Permission " + permission + " added with success to ECMS view " + viewNodeName));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Can not find view node: " + viewNodeName));
        }
    }

    public void deployContentToSpaceDrive(SessionProvider sessionProvider, String spaceId, DeploymentDescriptor deploymentDescriptor) throws Exception {
        String sourcePath = deploymentDescriptor.getSourcePath();
        LOG.info((Object)("Deploying '" + sourcePath + "'content to '" + spaceId + "' Space JCR location"));
        Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
        InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
        String targetNodePath = deploymentDescriptor.getTarget().getNodePath();
        if (targetNodePath.indexOf("/") == 0) {
            targetNodePath = targetNodePath.replaceFirst("/", "");
        }
        if (targetNodePath.lastIndexOf("/") == targetNodePath.length() - 1) {
            targetNodePath = targetNodePath.substring(0, targetNodePath.lastIndexOf("/"));
        }
        if (!targetNodePath.equals("")) {
            Node spaceRootNode = (Node)session.getItem(this.groupsPath + spaceId);
            Utils.makePath((Node)spaceRootNode, (String)targetNodePath, (String)"nt:unstructured");
        }
        String fullTargetNodePath = this.groupsPath + spaceId + "/" + targetNodePath;
        Node parentTargetNode = (Node)session.getItem(fullTargetNodePath);
        NodeIterator nodeIterator = parentTargetNode.getNodes();
        ArrayList<String> initialChildNodesUUID = new ArrayList<String>();
        ArrayList<String> initialChildNodesNames = new ArrayList<String>();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            String uuid = null;
            try {
                uuid = node.getUUID();
            }
            catch (Exception exception) {
                continue;
            }
            initialChildNodesUUID.add(uuid);
            initialChildNodesNames.add(node.getName());
        }
        session.importXML(fullTargetNodePath, inputStream, 0);
        parentTargetNode = (Node)session.getItem(fullTargetNodePath);
        nodeIterator = parentTargetNode.getNodes();
        ArrayList<ExtendedNode> newChildNodesUUID = new ArrayList<ExtendedNode>();
        while (nodeIterator.hasNext()) {
            ExtendedNode childNode = (ExtendedNode)nodeIterator.nextNode();
            String uuid = null;
            try {
                uuid = childNode.getUUID();
            }
            catch (Exception exception) {
                continue;
            }
            if (initialChildNodesUUID.contains(uuid)) continue;
            if (initialChildNodesNames.contains(childNode.getName())) {
                LOG.info((Object)(childNode.getName() + " already exists under " + fullTargetNodePath + ". This node will not be imported!"));
                childNode.remove();
                continue;
            }
            newChildNodesUUID.add(childNode);
        }
        String spaceMembershipManager = this.userACL.getAdminMSType() + ":" + spaceId;
        for (ExtendedNode extendedNode : newChildNodesUUID) {
            if (extendedNode.isNodeType("exo:privilegeable")) {
                extendedNode.clearACL();
            } else if (extendedNode.canAddMixin("exo:privilegeable")) {
                extendedNode.addMixin("exo:privilegeable");
                extendedNode.clearACL();
            } else {
                throw new IllegalStateException("Can't change permissions on node imported to the added Space.");
            }
            extendedNode.setPermission(IdentityConstants.ANY, new String[]{"read"});
            extendedNode.setPermission(spaceMembershipManager, PermissionType.ALL);
            if (!cleanupPublication.booleanValue() || !extendedNode.hasProperty("publication:liveRevision") || !extendedNode.hasProperty("publication:currentState")) continue;
            LOG.info((Object)("\"" + extendedNode.getName() + "\" publication lifecycle has been cleaned up"));
            extendedNode.setProperty("publication:liveRevision", "");
            extendedNode.setProperty("publication:currentState", "published");
        }
        session.save();
        session.logout();
        LOG.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + fullTargetNodePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSpaceHomePage(String spacePrettyName, String spaceGroupId, ExoProperties welcomeSCVCustomPreferences) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            LOG.info((Object)("Updating '" + spaceGroupId + "' Space Home Page"));
            Space space = this.getSpaceService().getSpaceByGroupId(spaceGroupId);
            if (space == null) {
                throw new IllegalStateException("Can't find space with group id " + spaceGroupId);
            }
            String spaceType = space.getType();
            SpaceTemplateService spaceTemplateService = this.getSpaceTemplateService();
            SpaceTemplate spaceTemplate = spaceTemplateService.getSpaceTemplateByName(spaceType);
            if (spaceTemplate == null) {
                LOG.warn("Could not find space template:{}. Space home page will not be created for space:{}.", new Object[]{spaceType, spacePrettyName});
                return;
            }
            SpaceApplication homeApplication = spaceTemplate.getSpaceHomeApplication();
            if (homeApplication == null) {
                LOG.warn("Could not find home application for template:{}. Space home page will not be created for space:{}.", new Object[]{spaceType, spacePrettyName});
                return;
            }
            String portletName = homeApplication.getPortletName();
            String pageName = PortalConfig.GROUP_TYPE + "::" + spaceGroupId + "::" + portletName;
            Page oldSpaceHomePage = this.dataStorageService.getPage(pageName);
            PageContext pageContext = this.pageService.loadPage(PageKey.parse((String)oldSpaceHomePage.getPageId()));
            pageContext.update(oldSpaceHomePage);
            Page customSpaceHomePage = this.userPortalConfigService.createPageTemplate(SPACE_NEW_HOME_PAGE_TEMPLATE, PortalConfig.GROUP_TYPE, spaceGroupId);
            customSpaceHomePage.setTitle(oldSpaceHomePage.getTitle());
            customSpaceHomePage.setName(oldSpaceHomePage.getName());
            customSpaceHomePage.setAccessPermissions(oldSpaceHomePage.getAccessPermissions());
            customSpaceHomePage.setEditPermission(oldSpaceHomePage.getEditPermission());
            customSpaceHomePage.setOwnerType(PortalConfig.GROUP_TYPE);
            customSpaceHomePage.setOwnerId(spaceGroupId);
            this.editChildrenAccesPermisions(customSpaceHomePage.getChildren(), customSpaceHomePage.getAccessPermissions());
            this.editSpaceURLPreference(customSpaceHomePage.getChildren(), spacePrettyName);
            Application<Portlet> welcomeSCVPortlet = this.getPortletApplication(customSpaceHomePage.getChildren(), SCV_PORTLEt_NAME);
            this.editSCVPreference(welcomeSCVPortlet, spaceGroupId, welcomeSCVCustomPreferences);
            NavigationContext navContext = SpaceUtils.createGroupNavigation((String)spaceGroupId);
            SiteKey siteKey = navContext.getKey();
            PageKey pageKey = new PageKey(siteKey, customSpaceHomePage.getName());
            PageState pageState = new PageState(customSpaceHomePage.getTitle(), customSpaceHomePage.getDescription(), customSpaceHomePage.isShowMaxWindow(), customSpaceHomePage.getFactoryId(), customSpaceHomePage.getAccessPermissions() != null ? Arrays.asList(customSpaceHomePage.getAccessPermissions()) : null, customSpaceHomePage.getEditPermission());
            this.pageService.savePage(new PageContext(pageKey, pageState));
            this.dataStorageService.save(customSpaceHomePage);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while customizing the Space home page for space: " + spaceGroupId), (Throwable)e);
        }
        finally {
            try {
                RequestLifeCycle.end();
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception has occurred while proceed RequestLifeCycle.end() : " + e.getMessage()));
            }
        }
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    public SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)CommonsUtils.getService(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    public void createSpaceDefaultFolders(String groupId) throws Exception {
        String groupPath;
        String spaceParentPath;
        ManageableRepository currentRepository;
        String workspaceName;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(workspaceName = (currentRepository = this.repositoryService.getCurrentRepository()).getConfiguration().getDefaultWorkspaceName(), currentRepository);
        if (!session.itemExists(spaceParentPath = (groupPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH)) + groupId + "/Documents")) {
            throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
        }
        Node parentNode = (Node)session.getItem(spaceParentPath);
        if (!parentNode.hasNode(ACTIVITY_FOLDER_UPLOAD_NAME)) {
            parentNode.addNode(ACTIVITY_FOLDER_UPLOAD_NAME);
            session.save();
        }
    }

    private void editSCVPreference(Application<Portlet> selectedPortlet, String prefValue, ExoProperties welcomeSCVCustomPreferences) throws Exception {
        Portlet prefs = (Portlet)this.dataStorageService.load(selectedPortlet.getState(), ApplicationType.PORTLET);
        if (prefs == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The portlet prefs == null : portlet application " + selectedPortlet.getId()));
            }
            prefs = new Portlet();
        }
        for (String preferenceName : welcomeSCVCustomPreferences.keySet()) {
            String preferenceValue = (String)welcomeSCVCustomPreferences.get((Object)preferenceName);
            if (preferenceValue.contains(SPACE_GROUP_ID_PREFERENCE)) {
                preferenceValue = preferenceValue.replace(SPACE_GROUP_ID_PREFERENCE, prefValue);
            }
            prefs.putPreference(new Preference(preferenceName, preferenceValue, false));
        }
    }

    private void editSpaceURLPreference(List<ModelObject> children, String prefValue) throws Exception {
        if ((children == null || children.size() == 0) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Container) {
                this.editSpaceURLPreference(((Container)modelObject).getChildren(), prefValue);
                continue;
            }
            if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
            Application application = (Application)modelObject;
            Portlet portletPreference = (Portlet)this.dataStorageService.load(application.getState(), ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new Portlet();
            }
            portletPreference.putPreference(new Preference("SPACE_URL", prefValue, false));
        }
    }

    private Application<Portlet> getPortletApplication(List<ModelObject> children, String portletName) throws Exception {
        if ((children == null || children.size() == 0) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            Application application;
            String portletId;
            Application selectedApplication = null;
            if (modelObject instanceof Container) {
                selectedApplication = this.getPortletApplication(((Container)modelObject).getChildren(), portletName);
            } else if (modelObject instanceof Application && ((Application)modelObject).getType().equals(ApplicationType.PORTLET) && (portletId = this.dataStorageService.getId((application = (Application)modelObject).getState())).endsWith("/" + portletName)) {
                selectedApplication = application;
            }
            if (selectedApplication == null) continue;
            return selectedApplication;
        }
        return null;
    }

    private void editChildrenAccesPermisions(List<ModelObject> children, String[] accessPermissions) {
        if (children != null && children.size() > 0) {
            for (ModelObject modelObject : children) {
                if (modelObject instanceof Container) {
                    ((Container)modelObject).setAccessPermissions(accessPermissions);
                    this.editChildrenAccesPermisions(((Container)modelObject).getChildren(), accessPermissions);
                    continue;
                }
                if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
                Application application = (Application)modelObject;
                application.setAccessPermissions(accessPermissions);
            }
        }
    }
}

