/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIFormInputSetWithActionForTaggingForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITaggingFormContainer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaggingForm
extends UIForm {
    public static final String TAG_NAME_LIST = "tagNameList";
    public static final String TAG_NAMES = "names";
    public static final String TAG_SCOPES = "tagScopes";
    public static final String LINKED_TAGS = "linked";
    public static final String LINKED_TAGS_SET = "tagSet";
    private static final String USER_FOLKSONOMY_ALIAS = "userPrivateFolksonomy";
    private static final String GROUP_FOLKSONOMY_ALIAS = "folksonomy";
    private static final String GROUPS_ALIAS = "groupsPath";
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";

    public UITaggingForm() throws Exception {
        UIFormInputSetWithActionForTaggingForm uiInputSet = new UIFormInputSetWithActionForTaggingForm(LINKED_TAGS_SET);
        uiInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(TAG_NAMES, TAG_NAMES, null));
        uiInputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(TAG_NAME_LIST, TAG_NAME_LIST, null));
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        ArrayList<SelectItemOption> tagScopes = new ArrayList<SelectItemOption>();
        tagScopes.add(new SelectItemOption(res.getString("UITaggingForm.label.Public"), (Object)"Public"));
        UIFormSelectBox box = new UIFormSelectBox(TAG_SCOPES, TAG_SCOPES, tagScopes);
        box.setOnChange("Change");
        uiInputSet.addUIFormInput((UIFormInput)box);
        box.setSelectedValues(new String[]{"Public"});
        box.setRendered(false);
        uiInputSet.addUIFormInput((UIFormInput)new UIFormInputInfo(LINKED_TAGS, LINKED_TAGS, null));
        uiInputSet.setIntroduction(TAG_NAMES, "UITaggingForm.introduction.tagName");
        this.addUIComponentInput((UIComponent)uiInputSet);
        uiInputSet.setIsView(false);
        super.setActions(new String[]{"Cancel"});
    }

    public void activate() throws Exception {
        String[] stringArray;
        String workspace = WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName();
        NewFolksonomyService folksonomyService = (NewFolksonomyService)WCMCoreUtils.getService(NewFolksonomyService.class);
        StringBuilder linkedTags = new StringBuilder();
        HashSet<String> linkedTagSet = new HashSet<String>();
        String tagScope = (String)this.getUIFormSelectBox(TAG_SCOPES).getValue();
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).setTagScope(this.getIntValue(tagScope));
        for (Object tag : folksonomyService.getLinkedTagsOfDocumentByScope(this.getIntValue(tagScope), this.getStrValue(tagScope, currentNode), currentNode, workspace)) {
            linkedTagSet.add(tag.getName());
        }
        ArrayList linkedTagList = new ArrayList(linkedTagSet);
        Collections.sort(linkedTagList);
        for (String tagName : linkedTagList) {
            if (linkedTags.length() > 0) {
                linkedTags = linkedTags.append(",");
            }
            linkedTags.append(tagName);
        }
        UIFormInputSetWithAction uiLinkedInput = (UIFormInputSetWithAction)this.getChildById(LINKED_TAGS_SET);
        uiLinkedInput.setInfoField(LINKED_TAGS, linkedTags.toString());
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)WCMCoreUtils.getService(NewFolksonomyService.class);
        List memberships = Utils.getMemberships();
        if (newFolksonomyService.canEditTag(this.getIntValue(tagScope), memberships)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Edit";
            stringArray = stringArray2;
            stringArray2[1] = "Remove";
        } else {
            stringArray = null;
        }
        String[] actionsForTags = stringArray;
        uiLinkedInput.setActionInfo(LINKED_TAGS, actionsForTags);
        uiLinkedInput.setIsShowOnly(true);
        uiLinkedInput.setIsDeleteOnly(false);
    }

    public void deActivate() throws Exception {
    }

    public int getIntValue(String scope) {
        if ("Public".equals(scope)) {
            return 0;
        }
        if ("Group".equals(scope)) {
            return 3;
        }
        if ("Private".equals(scope)) {
            return 1;
        }
        return 2;
    }

    public List<String> getAllTagNames() throws Exception {
        String workspace = WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName();
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String tagScope = (String)this.getUIFormSelectBox(TAG_SCOPES).getValue();
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        return folksonomyService.getAllTagNames(workspace, this.getIntValue(tagScope), this.getStrValue(tagScope, currentNode));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.disableAutocomplete('UITaggingForm');");
        super.processRender(context);
    }

    private String getStrValue(String scope, Node node) throws Exception {
        StringBuilder ret = new StringBuilder();
        if ("Private".equals(scope)) {
            ret.append(node.getSession().getUserID());
        } else if ("Group".equals(scope)) {
            for (String group : Utils.getGroups()) {
                ret.append(group).append(';');
            }
            ret.deleteCharAt(ret.length() - 1);
        } else if ("Public".equals(scope)) {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
            ret.append(nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH));
        }
        return ret.toString();
    }

    public static class EditActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List memberships = Utils.getMemberships();
            if (!newFolksonomyService.canEditTag(uiForm.getIntValue(tagScope), memberships)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                return;
            }
            ((UITaggingFormContainer)uiForm.getParent()).edit(event);
        }
    }

    public static class ChangeActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            uiForm.activate();
        }
    }

    public static class RemoveActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List memberships = Utils.getMemberships();
            if (!newFolksonomyService.canEditTag(uiForm.getIntValue(tagScope), memberships)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                return;
            }
            Node currentNode = uiExplorer.getCurrentNode();
            String tagName = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (!Utils.isNameValid((String)tagName, (String[])Utils.SPECIALCHARACTER)) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-invalid", null, 1));
                return;
            }
            this.removeTagFromNode(tagScope, currentNode, tagName, uiForm);
            uiForm.activate();
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }

        public void removeTagFromNode(String scope, Node currentNode, String tagName, UITaggingForm uiForm) throws Exception {
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String userName = currentNode.getSession().getUserID();
            String workspace = WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName();
            if ("Public".equals(scope)) {
                String tagPath = newFolksonomyService.getDataDistributionType().getDataNode((Node)WCMCoreUtils.getUserSessionProvider().getSession(workspace, WCMCoreUtils.getRepository()).getItem(nodeHierarchyCreator.getJcrPath(UITaggingForm.PUBLIC_TAG_NODE_PATH)), tagName).getPath();
                newFolksonomyService.removeTagOfDocument(tagPath, currentNode, workspace);
            } else if ("Private".equals(scope)) {
                Node userFolksonomyNode = this.getUserFolksonomyFolder(userName, uiForm);
                String tagPath = newFolksonomyService.getDataDistributionType().getDataNode(userFolksonomyNode, tagName).getPath();
                newFolksonomyService.removeTagOfDocument(tagPath, currentNode, workspace);
            } else if ("Group".equals(scope)) {
                String groupsPath = nodeHierarchyCreator.getJcrPath(UITaggingForm.GROUPS_ALIAS);
                String folksonomyPath = nodeHierarchyCreator.getJcrPath(UITaggingForm.GROUP_FOLKSONOMY_ALIAS);
                Node groupsNode = this.getNode(workspace, groupsPath);
                for (String role : Utils.getGroups()) {
                    String tagPath = newFolksonomyService.getDataDistributionType().getDataNode(groupsNode.getNode(role).getNode(folksonomyPath), tagName).getPath();
                    newFolksonomyService.removeTagOfDocument(tagPath, currentNode, workspace);
                }
            }
        }

        private Node getNode(String workspace, String path) throws Exception {
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            return (Node)sessionProvider.getSession(workspace, WCMCoreUtils.getRepository()).getItem(path);
        }

        private Node getUserFolksonomyFolder(String userName, UITaggingForm uiForm) throws Exception {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            Node userNode = nodeHierarchyCreator.getUserNode(WCMCoreUtils.getUserSessionProvider(), userName);
            String folksonomyPath = nodeHierarchyCreator.getJcrPath(UITaggingForm.USER_FOLKSONOMY_ALIAS);
            return userNode.getNode(folksonomyPath);
        }
    }

    public static class CancelActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UITaggingForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class AddTagActionListener
    extends EventListener<UITaggingForm> {
        public void execute(Event<UITaggingForm> event) throws Exception {
            UITaggingForm uiForm = (UITaggingForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String workspace = ((UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class)).getRepository().getConfiguration().getDefaultWorkspaceName();
            String tagName = (String)uiForm.getUIStringInput(UITaggingForm.TAG_NAMES).getValue();
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.addLockToken(currentNode);
            if (tagName == null || tagName.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tag-name-empty", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            String[] tagNames = tagName.split(",");
            ArrayList<String> listTagNames = new ArrayList<String>(tagNames.length);
            ArrayList<String> listTagNamesClone = new ArrayList<String>(tagNames.length);
            if (tagName.contains(",")) {
                for (String tName : tagNames) {
                    listTagNames.add(tName.trim());
                    listTagNamesClone.add(tName.trim());
                }
                for (String tag : listTagNames) {
                    listTagNamesClone.remove(tag);
                    if (listTagNamesClone.contains(tag)) continue;
                    listTagNamesClone.add(tag);
                }
            } else {
                listTagNames.add(tagName.trim());
                listTagNamesClone.add(tagName.trim());
            }
            for (String t : listTagNames) {
                if (t.trim().length() == 0) {
                    listTagNamesClone.remove(t);
                    continue;
                }
                if (t.trim().length() > 30) {
                    listTagNamesClone.remove(t);
                    continue;
                }
                for (String filterChar : Utils.SPECIALCHARACTER) {
                    if (!t.contains(filterChar)) continue;
                    listTagNamesClone.remove(t);
                }
            }
            if (listTagNamesClone.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.tagName-empty-or-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            String tagScope = (String)uiForm.getUIFormSelectBox(UITaggingForm.TAG_SCOPES).getValue();
            List tagList = newFolksonomyService.getLinkedTagsOfDocumentByScope(uiForm.getIntValue(tagScope), uiForm.getStrValue(tagScope, currentNode), uiExplorer.getCurrentNode(), workspace);
            for (Node tag : tagList) {
                for (String t : listTagNames) {
                    if (!t.equals(tag.getName())) continue;
                    listTagNamesClone.remove(t);
                }
            }
            if (listTagNamesClone.size() > 0) {
                this.addTagToNode(tagScope, currentNode, listTagNamesClone.toArray(new String[listTagNamesClone.size()]), uiForm);
            }
            uiForm.activate();
            Preference preferences = uiExplorer.getPreference();
            if (preferences.isShowSideBar()) {
                UISideBar uiSideBar = (UISideBar)uiExplorer.findFirstComponentOfType(UISideBar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
            }
            uiForm.getUIStringInput(UITaggingForm.TAG_NAMES).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }

        private void addTagToNode(String scope, Node currentNode, String[] tagNames, UITaggingForm uiForm) throws Exception {
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
            ManageableRepository manageableRepo = WCMCoreUtils.getRepository();
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)uiForm.getApplicationComponent(NodeHierarchyCreator.class);
            String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
            List groups = Utils.getGroups();
            String[] roles = groups.toArray(new String[groups.size()]);
            String publicTagNodePath = nodeHierarchyCreator.getJcrPath(UITaggingForm.PUBLIC_TAG_NODE_PATH);
            if ("Public".equals(scope)) {
                newFolksonomyService.addPublicTag(publicTagNodePath, tagNames, currentNode, workspace);
            } else if ("Group".equals(scope)) {
                newFolksonomyService.addGroupsTag(tagNames, currentNode, workspace, roles);
            } else if ("Private".equals(scope)) {
                String userName = currentNode.getSession().getUserID();
                newFolksonomyService.addPrivateTag(tagNames, currentNode, workspace, userName);
            }
        }
    }
}

