/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/content/")
public class NavigationConnector
implements ResourceContainer {
    private static ThreadLocal<Boolean> gotNavigationKeeper = new ThreadLocal();

    @GET
    @Path(value="/getFullNavigation/")
    public Response getFullNavigation(@QueryParam(value="portalName") String portalName) throws Exception {
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("navigationXML");
        element.setTextContent(this.getNavigationAsJSON(portalName, userName));
        document.appendChild(element);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").build();
    }

    private String getNavigationAsJSON(String portalName, String username) throws Exception {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalConfig userPortalCfg = userPortalConfigService.getUserPortalConfig(portalName, username);
        UserPortal userPortal = userPortalCfg.getUserPortal();
        UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
        filterConfigBuilder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        filterConfigBuilder.withTemporalCheck();
        UserNodeFilterConfig filterConfig = filterConfigBuilder.build();
        UserNavigation navigation = userPortal.getNavigation(SiteKey.portal((String)portalName));
        UserNode root = userPortal.getNode(navigation, Scope.ALL, filterConfig, null);
        gotNavigationKeeper.set(true);
        return this.createJsonTree(navigation, root);
    }

    private String createJsonTree(UserNavigation navigation, UserNode rootNode) throws Exception {
        StringBuffer sbJsonTree = new StringBuffer();
        sbJsonTree.append("[");
        sbJsonTree.append("{");
        sbJsonTree.append("\"ownerId\":\"").append(navigation.getKey().getName()).append("\",");
        sbJsonTree.append("\"ownerType\":\"").append(navigation.getKey().getTypeName()).append("\",");
        sbJsonTree.append("\"priority\":\"").append(navigation.getPriority()).append("\",");
        sbJsonTree.append("\"nodes\":").append(this.addJsonNodes(rootNode.getChildren().iterator()));
        sbJsonTree.append("}");
        sbJsonTree.append("]");
        return sbJsonTree.toString();
    }

    private StringBuffer addJsonNodes(Iterator<UserNode> children) {
        StringBuffer sbJsonTree = new StringBuffer();
        String resovleLabel = "";
        sbJsonTree.append("[");
        boolean first = true;
        while (children.hasNext()) {
            UserNode child = children.next();
            if (!first) {
                sbJsonTree.append(",");
            }
            first = false;
            sbJsonTree.append("{");
            sbJsonTree.append("\"icon\":").append((String)(child.getIcon() != null ? "\"" + child.getIcon() + "\"" : "null")).append(",");
            sbJsonTree.append("\"label\":\"").append(child.getLabel()).append("\",");
            sbJsonTree.append("\"name\":\"").append(child.getName()).append("\",");
            try {
                resovleLabel = child.getResolvedLabel();
            }
            catch (NullPointerException npe) {
                resovleLabel = "";
            }
            sbJsonTree.append("\"resolvedLabel\":\"").append(resovleLabel).append("\",");
            sbJsonTree.append("\"uri\":\"").append(child.getURI()).append("\",");
            sbJsonTree.append("\"getNodeURL\":\"").append(child.getURI().toString()).append("\",");
            sbJsonTree.append("\"nodes\":").append(this.addJsonNodes(child.getChildren().iterator()));
            sbJsonTree.append("}");
        }
        sbJsonTree.append("]");
        return sbJsonTree;
    }
}

