/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.uploads;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class HTMLUploadImageProcessorImpl
implements HTMLUploadImageProcessor {
    public static final String IP_REGEX = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
    public static final String URL_OR_URI_REGEX = "^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    private static final Log LOG = ExoLogger.getLogger(HTMLUploadImageProcessorImpl.class);
    private static final Pattern UPLOAD_ID_PATTERN = Pattern.compile("uploadId=(([0-9]|[a-f]|[A-F])*)");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("[//]|.*?|[-//]");
    private static final Pattern UPLOAD_URL_PATTERN = Pattern.compile("^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    private static final String IMAGE_URL_REPLACEMENT_PREFIX = "//-";
    private static final String IMAGE_URL_REPLACEMENT_SUFFIX = "-//";
    private final PortalContainer portalContainer;
    private final UploadService uploadService;
    private final RepositoryService repositoryService;
    private final LinkManager linkManager;
    private final SessionProviderService sessionProviderService;
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final WCMService wcmService;
    private String repositoryName;

    public HTMLUploadImageProcessorImpl(PortalContainer portalContainer, UploadService uploadService, RepositoryService repositoryService, LinkManager linkManager, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, WCMService wcmService) {
        this.portalContainer = portalContainer;
        this.uploadService = uploadService;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
        this.sessionProviderService = sessionProviderService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.wcmService = wcmService;
    }

    private static String getURLToReplace(String body, String uploadId, int uploadIdIndex) {
        int srcBeginIndex = body.lastIndexOf("\"", uploadIdIndex);
        int srcEndIndex = -1;
        if (srcBeginIndex < 0) {
            srcBeginIndex = body.lastIndexOf("'", uploadIdIndex);
            if (srcBeginIndex < 0) {
                LOG.warn((Object)("Cannot find src start delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
            } else {
                srcEndIndex = body.indexOf("'", srcBeginIndex + 1);
            }
        } else {
            srcEndIndex = body.indexOf("\"", srcBeginIndex + 1);
        }
        String urlToReplace = null;
        if (srcEndIndex < 0) {
            LOG.warn((Object)("Cannot find src end delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
        } else {
            urlToReplace = body.substring(srcBeginIndex + 1, srcEndIndex);
        }
        return urlToReplace;
    }

    @Deprecated
    public String processImages(String content, String parentNodeId, String imagesSubFolderPath) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            Node parentNode = session.getNodeByUUID(parentNodeId);
            HashSet<String> processedUploads = new HashSet<String>();
            HashMap<String, String> urlToReplaces = new HashMap<String, String>();
            Matcher matcher = UPLOAD_ID_PATTERN.matcher(content);
            if (!matcher.find()) {
                return content;
            }
            Node imagesFolderNode = parentNode;
            if (StringUtils.isNotEmpty((CharSequence)imagesSubFolderPath)) {
                for (String folder : imagesSubFolderPath.split("/")) {
                    if (StringUtils.isBlank((CharSequence)folder)) continue;
                    if (imagesFolderNode.hasNode(folder)) {
                        if (!(imagesFolderNode = imagesFolderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                        imagesFolderNode = this.linkManager.getTarget(imagesFolderNode);
                        continue;
                    }
                    imagesFolderNode = imagesFolderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(imagesFolderNode).getNode(folder) : imagesFolderNode.addNode(folder, "nt:unstructured");
                }
            }
            String processedContent = content;
            do {
                UploadResource uploadedResource;
                String uploadId;
                if (processedUploads.contains(uploadId = matcher.group(matcher.groupCount() - 1)) || (uploadedResource = this.uploadService.getUploadResource(uploadId)) == null) continue;
                Object fileName = uploadedResource.getFileName();
                int i = 1;
                String originalFileName = fileName;
                while (imagesFolderNode.hasNode((String)fileName)) {
                    if (originalFileName.contains(".")) {
                        int indexOfPoint = originalFileName.indexOf(".");
                        fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                    } else {
                        fileName = originalFileName + "(" + i + ")";
                    }
                    ++i;
                }
                fileName = Text.escapeIllegalJcrChars((String)fileName);
                fileName = Utils.cleanName((String)fileName);
                Node imageNode = imagesFolderNode.addNode((String)fileName, "nt:file");
                Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
                resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
                resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
                String fileDiskLocation = uploadedResource.getStoreLocation();
                try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                    resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                    resourceNode.getSession().save();
                    parentNode.getSession().save();
                }
                this.uploadService.removeUploadResource(uploadId);
                int uploadIdIndex = matcher.start();
                String urlToReplace = HTMLUploadImageProcessorImpl.getURLToReplace(processedContent, uploadId, uploadIdIndex);
                if (!UPLOAD_URL_PATTERN.matcher(urlToReplace).matches()) {
                    LOG.warn("Unrecognized URL to replace in activity body {}", new Object[]{urlToReplace});
                    continue;
                }
                String fileURI = this.getJcrURI(imageNode);
                if (!StringUtils.isNotBlank((CharSequence)urlToReplace)) continue;
                urlToReplaces.put(urlToReplace, fileURI);
                processedUploads.add(uploadId);
            } while (matcher.find());
            processedContent = this.replaceUrl(content, urlToReplaces);
            return processedContent;
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Cannot find File location, content will not be changed", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create the image, content will not be changed", e);
        }
    }

    @Deprecated
    public String processSpaceImages(String content, String spaceGroupId, String imagesSubLocationPath) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        boolean uploadMode = false;
        boolean importMode = false;
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node groupNode = session.getRootNode().getNode("Groups");
            if (spaceGroupId.startsWith("/")) {
                spaceGroupId = spaceGroupId.substring(1);
            }
            Node parentNode = groupNode.getNode(spaceGroupId);
            Matcher matcher = UPLOAD_ID_PATTERN.matcher(content);
            Matcher matcherImport = IMPORT_PATTERN.matcher(content);
            if (matcher.find()) {
                uploadMode = true;
            } else if (matcherImport.find()) {
                importMode = true;
            }
            if (!uploadMode && !importMode) {
                return content;
            }
            if (parentNode == null) {
                throw new IllegalArgumentException("Container node for uploaded processed images in HTML content must not be null");
            }
            Node imagesFolderNode = parentNode;
            if (StringUtils.isNotEmpty((CharSequence)imagesSubLocationPath)) {
                for (String folder : imagesSubLocationPath.split("/")) {
                    if (imagesFolderNode.canAddMixin("exo:privilegeable")) {
                        imagesFolderNode.addMixin("exo:privilegeable");
                    }
                    HashMap<CallSite, String[]> permissions = new HashMap<CallSite, String[]>();
                    permissions.put((CallSite)((Object)("*:/" + spaceGroupId)), PermissionType.ALL);
                    ((ExtendedNode)imagesFolderNode).setPermissions(permissions);
                    if (StringUtils.isBlank((CharSequence)folder)) continue;
                    if (imagesFolderNode.hasNode(folder)) {
                        if (!(imagesFolderNode = imagesFolderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                        imagesFolderNode = this.linkManager.getTarget(imagesFolderNode);
                        continue;
                    }
                    imagesFolderNode = imagesFolderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(imagesFolderNode).getNode(folder) : imagesFolderNode.addNode(folder, "nt:unstructured");
                }
            }
            if (uploadMode) {
                content = this.createImagesfromUpload(content, imagesFolderNode, parentNode);
            }
            if (importMode) {
                content = this.createImagesfromImport(content, imagesFolderNode, parentNode);
            }
            return content;
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Cannot find File location", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create the image", e);
        }
    }

    @Deprecated
    public String processUserImages(String content, String userId, String imagesSubLocationPath) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        boolean uploadMode = false;
        boolean importMode = false;
        SessionProvider sessionProvider = null;
        try {
            Node parentNode;
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Node imagesFolderNode = parentNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userId);
            Matcher matcher = UPLOAD_ID_PATTERN.matcher(content);
            Matcher matcherImport = IMPORT_PATTERN.matcher(content);
            if (matcher.find()) {
                uploadMode = true;
            } else if (matcherImport.find()) {
                importMode = true;
            }
            if (!uploadMode && !importMode) {
                return content;
            }
            if (StringUtils.isNotEmpty((CharSequence)imagesSubLocationPath)) {
                for (String folder : imagesSubLocationPath.split("/")) {
                    if (StringUtils.isBlank((CharSequence)folder)) continue;
                    if (imagesFolderNode.hasNode(folder)) {
                        if (!(imagesFolderNode = imagesFolderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                        imagesFolderNode = this.linkManager.getTarget(imagesFolderNode);
                        continue;
                    }
                    imagesFolderNode = imagesFolderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(imagesFolderNode).getNode(folder) : imagesFolderNode.addNode(folder, "nt:unstructured");
                }
            }
            if (uploadMode) {
                content = this.createImagesfromUpload(content, imagesFolderNode, parentNode);
            }
            if (importMode) {
                content = this.createImagesfromImport(content, imagesFolderNode, parentNode);
            }
            return content;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create the image", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot find user data location", e);
        }
    }

    public void uploadSpaceFile(String filePath, String spaceGroupId, String fileName, String imagesSubLocationPath) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return;
        }
        SessionProvider sessionProvider = null;
        try {
            File file;
            Node folderNode;
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node groupNode = session.getRootNode().getNode("Groups");
            if (spaceGroupId.startsWith("/")) {
                spaceGroupId = spaceGroupId.substring(1);
            }
            if ((folderNode = groupNode.getNode(spaceGroupId)) == null) {
                throw new IllegalArgumentException("Container node for uploaded processed images in HTML content must not be null");
            }
            if (StringUtils.isNotEmpty((CharSequence)imagesSubLocationPath)) {
                for (String folder : imagesSubLocationPath.split("/")) {
                    if (StringUtils.isBlank((CharSequence)folder)) continue;
                    if (folderNode.hasNode(folder)) {
                        if (!(folderNode = folderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                        folderNode = this.linkManager.getTarget(folderNode);
                        continue;
                    }
                    folderNode = folderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(folderNode).getNode(folder) : folderNode.addNode(folder, "nt:unstructured");
                }
            }
            if (!(file = new File(filePath)).exists()) {
                return;
            }
            int i = 1;
            String originalFileName = fileName;
            while (folderNode.hasNode((String)fileName)) {
                if (originalFileName.contains(".")) {
                    int indexOfPoint = originalFileName.indexOf(".");
                    fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                } else {
                    fileName = originalFileName + "(" + i + ")";
                }
                ++i;
            }
            fileName = Text.escapeIllegalJcrChars((String)fileName);
            fileName = Utils.cleanName((String)fileName);
            Node imageNode = folderNode.addNode((String)fileName, "nt:file");
            Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:mimeType", URLConnection.guessContentTypeFromName(file.getName()));
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            try (FileInputStream inputStream = new FileInputStream(file);){
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                resourceNode.getSession().save();
                folderNode.getSession().save();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create the image", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot find user data location", e);
        }
    }

    public void uploadUserFile(String filePath, String userId, String fileName, String imagesSubLocationPath) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return;
        }
        SessionProvider sessionProvider = null;
        try {
            File file;
            Node parentNode;
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Node folderNode = parentNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userId);
            if (StringUtils.isNotEmpty((CharSequence)imagesSubLocationPath)) {
                for (String folder : imagesSubLocationPath.split("/")) {
                    if (StringUtils.isBlank((CharSequence)folder)) continue;
                    if (folderNode.hasNode(folder)) {
                        if (!(folderNode = folderNode.getNode(folder)).isNodeType("exo:symlink")) continue;
                        folderNode = this.linkManager.getTarget(folderNode);
                        continue;
                    }
                    folderNode = folderNode.isNodeType("exo:symlink") ? this.linkManager.getTarget(folderNode).getNode(folder) : folderNode.addNode(folder, "nt:unstructured");
                }
            }
            if (!(file = new File(filePath)).exists()) {
                return;
            }
            int i = 1;
            String originalFileName = fileName;
            while (folderNode.hasNode((String)fileName)) {
                if (originalFileName.contains(".")) {
                    int indexOfPoint = originalFileName.indexOf(".");
                    fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                } else {
                    fileName = originalFileName + "(" + i + ")";
                }
                ++i;
            }
            fileName = Text.escapeIllegalJcrChars((String)fileName);
            fileName = Utils.cleanName((String)fileName);
            Node imageNode = folderNode.addNode((String)fileName, "nt:file");
            Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:mimeType", URLConnection.guessContentTypeFromName(file.getName()));
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            try (FileInputStream inputStream = new FileInputStream(file);){
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                resourceNode.getSession().save();
                parentNode.getSession().save();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create the image", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot find user data location", e);
        }
    }

    public String processImagesForExport(String content_) throws IllegalArgumentException {
        SessionProvider sessionProvider = null;
        try {
            HashMap<String, String> urlToReplaces = new HashMap<String, String>();
            String content = content_;
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            String restUploadUrl = "/" + this.portalContainer.getName() + "/" + this.portalContainer.getRestContextName() + "/images/" + this.getRepositoryName() + "/";
            while (content.contains(restUploadUrl)) {
                String check_content = content;
                String workspace = content.split(restUploadUrl)[1].split("\"")[0];
                String nodeIdentifier = workspace.split("/")[1].split("\\?")[0];
                workspace = workspace.split("/")[0];
                String urlToReplace = restUploadUrl + workspace + "/" + nodeIdentifier;
                try {
                    Node dataNode = this.wcmService.getReferencedContent(sessionProvider, workspace, nodeIdentifier);
                    if (dataNode != null) {
                        String fileName = dataNode.getName();
                        Node jcrContentNode = dataNode.getNode("jcr:content");
                        InputStream jcrData = jcrContentNode.getProperty("jcr:data").getStream();
                        File tempFile = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName);
                        try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                            IOUtils.copy((InputStream)jcrData, (OutputStream)outputStream);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Cannot create the image", e);
                        }
                        urlToReplaces.put(urlToReplace, IMAGE_URL_REPLACEMENT_PREFIX + tempFile.getName() + IMAGE_URL_REPLACEMENT_SUFFIX);
                    }
                    content = content.replace(urlToReplace, "");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create the image from workspace: " + workspace + " node id " + nodeIdentifier, e);
                }
                if (!check_content.equals(content)) continue;
                break;
            }
            if (!urlToReplaces.isEmpty()) {
                content_ = this.replaceUrl(content_, urlToReplaces);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot process the content", e);
        }
        return content_;
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        block0: for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                String check_content = body;
                if (!(body = body.replace(url, urlToReplaces.get(url))).equals(check_content)) continue;
                continue block0;
            }
        }
        return body;
    }

    private String getJcrURI(Node imageNode) throws RepositoryException {
        if (!imageNode.isNodeType("mix:referenceable")) {
            imageNode.addMixin("mix:referenceable");
        }
        return "/" + this.portalContainer.getName() + "/" + this.portalContainer.getRestContextName() + "/images/" + this.getRepositoryName() + "/" + imageNode.getSession().getWorkspace().getName() + "/" + imageNode.getUUID();
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            try {
                this.repositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                this.repositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
            }
        }
        return this.repositoryName;
    }

    private String createImagesfromUpload(String content, Node imagesFolderNode, Node parentNode) throws RepositoryException, IOException {
        HashSet<String> processedUploads = new HashSet<String>();
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        String processedContent = content;
        Matcher matcher = UPLOAD_ID_PATTERN.matcher(content);
        matcher.find();
        do {
            UploadResource uploadedResource;
            String uploadId;
            if (processedUploads.contains(uploadId = matcher.group(matcher.groupCount() - 1)) || (uploadedResource = this.uploadService.getUploadResource(uploadId)) == null) continue;
            Object fileName = uploadedResource.getFileName();
            int i = 1;
            String originalFileName = fileName;
            while (imagesFolderNode.hasNode((String)fileName)) {
                if (originalFileName.contains(".")) {
                    int indexOfPoint = originalFileName.indexOf(".");
                    fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                } else {
                    fileName = originalFileName + "(" + i + ")";
                }
                ++i;
            }
            fileName = Text.escapeIllegalJcrChars((String)fileName);
            fileName = Utils.cleanName((String)fileName);
            Node imageNode = imagesFolderNode.addNode((String)fileName, "nt:file");
            Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            String fileDiskLocation = uploadedResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                resourceNode.getSession().save();
                parentNode.getSession().save();
            }
            this.uploadService.removeUploadResource(uploadId);
            int uploadIdIndex = matcher.start();
            String urlToReplace = HTMLUploadImageProcessorImpl.getURLToReplace(processedContent, uploadId, uploadIdIndex);
            if (!UPLOAD_URL_PATTERN.matcher(urlToReplace).matches()) {
                LOG.warn("Unrecognized URL to replace in activity body {}", new Object[]{urlToReplace});
                continue;
            }
            String fileURI = this.getJcrURI(imageNode);
            if (!StringUtils.isNotBlank((CharSequence)urlToReplace)) continue;
            urlToReplaces.put(urlToReplace, fileURI);
            processedUploads.add(uploadId);
        } while (matcher.find());
        return this.replaceUrl(content, urlToReplaces);
    }

    private String createImagesfromImport(String content, Node imagesFolderNode, Node parentNode) throws RepositoryException, IOException {
        HashSet processedUploads = new HashSet();
        String processedContent = content;
        while (processedContent.contains("src=\"//-")) {
            String check_content = processedContent;
            Object fileName = processedContent.split("src=\"//-")[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
            if (!processedUploads.contains(fileName)) {
                File file = new File(System.getProperty("java.io.tmpdir") + File.separator + (String)fileName);
                if (!file.exists()) {
                    String urlToReplace = IMAGE_URL_REPLACEMENT_PREFIX + (String)fileName + IMAGE_URL_REPLACEMENT_SUFFIX;
                    processedContent = processedContent.replace(urlToReplace, "");
                    continue;
                }
                fileName = file.getName();
                int i = 1;
                String originalFileName = fileName;
                while (imagesFolderNode.hasNode((String)fileName)) {
                    if (originalFileName.contains(".")) {
                        int indexOfPoint = originalFileName.indexOf(".");
                        fileName = originalFileName.substring(0, indexOfPoint) + "(" + i + ")" + originalFileName.substring(indexOfPoint);
                    } else {
                        fileName = originalFileName + "(" + i + ")";
                    }
                    ++i;
                }
                fileName = Text.escapeIllegalJcrChars((String)fileName);
                fileName = Utils.cleanName((String)fileName);
                Node imageNode = imagesFolderNode.addNode((String)fileName, "nt:file");
                Node resourceNode = imageNode.addNode("jcr:content", "nt:resource");
                resourceNode.setProperty("jcr:mimeType", URLConnection.guessContentTypeFromName(file.getName()));
                resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
                try (FileInputStream inputStream = new FileInputStream(file);){
                    resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                    resourceNode.getSession().save();
                    parentNode.getSession().save();
                }
                String urlToReplace = IMAGE_URL_REPLACEMENT_PREFIX + file.getName() + IMAGE_URL_REPLACEMENT_SUFFIX;
                String fileURI = this.getJcrURI(imageNode);
                if (StringUtils.isNotBlank((CharSequence)urlToReplace)) {
                    processedContent = processedContent.replace(urlToReplace, fileURI);
                }
                file.delete();
            }
            if (!processedContent.equals(check_content)) continue;
            break;
        }
        return processedContent;
    }
}

