/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.NavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPortalNavigationExplorer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationHistory;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPages;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPagesContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationTree;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublishedPages;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublicationAction.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class})})
public class UIPublicationAction
extends UIForm {
    public void updateUI() throws Exception {
        UIPublicationPages publicationPages = (UIPublicationPages)this.getAncestorOfType(UIPublicationPages.class);
        UIPublishedPages publishedPages = (UIPublishedPages)publicationPages.getChild(UIPublishedPages.class);
        Node node = publicationPages.getNode();
        ArrayList<String> listPublishedPage = new ArrayList<String>();
        if (node.hasProperty("publication:navigationNodeURIs")) {
            Value[] navigationNodeURIs;
            for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                if (!PublicationUtil.isNodeContentPublishedToPageNode((Node)node, (String)navigationNodeURI.getString())) continue;
                listPublishedPage.add(navigationNodeURI.getString());
            }
            publishedPages.setListNavigationNodeURI(listPublishedPage);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
            UIPublicationHistory publicationHistory = (UIPublicationHistory)publicationContainer.getChild(UIPublicationHistory.class);
            UIPublicationPanel publicationPanel = (UIPublicationPanel)publicationContainer.getChild(UIPublicationPanel.class);
            publicationHistory.init(publicationPanel.getCurrentNode());
            publicationHistory.updateGrid();
        }
    }

    public static class RemoveActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublicationPages publicationPages = (UIPublicationPages)publicationAction.getAncestorOfType(UIPublicationPages.class);
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)publicationAction.getApplicationComponent(UserPortalConfigService.class);
            UIPublishedPages publishedPages = (UIPublishedPages)publicationPages.getChild(UIPublishedPages.class);
            String selectedNavigationNodeURI = publishedPages.getSelectedNavigationNodeURI();
            if (selectedNavigationNodeURI == null) {
                UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                return;
            }
            String portalName = selectedNavigationNodeURI.substring(1, selectedNavigationNodeURI.indexOf("/", 1));
            String pageNodeUri = selectedNavigationNodeURI.replaceFirst("/\\w+/", "");
            UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
            UserNavigation navigation = NavigationUtils.getUserNavigationOfPortal((UserPortal)userPortal, (String)portalName);
            Node contentNode = null;
            if (navigation != null && (contentNode = publicationPages.getNode()).hasProperty("publication:applicationIDs")) {
                UserNode userNode = this.getUserNodeByUri(navigation, pageNodeUri);
                userPortalConfigService.getPage(userNode.getPageRef());
            }
            publicationAction.updateUI();
            UIPublicationPagesContainer publicationPagesContainer = (UIPublicationPagesContainer)publicationPages.getAncestorOfType(UIPublicationPagesContainer.class);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationAction.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPagesContainer, event.getRequestContext());
        }

        private UserNode getUserNodeByUri(UserNavigation pageNav, String uri) {
            if (pageNav == null || uri == null) {
                return null;
            }
            return ((UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class)).getSiteNodeOrGlobalNode(pageNav.getKey().getTypeName(), pageNav.getKey().getName(), uri, ConversationState.getCurrent().getIdentity().getUserId());
        }
    }

    public static class AddActionListener
    extends EventListener<UIPublicationAction> {
        public void execute(Event<UIPublicationAction> event) throws Exception {
            UserNode userNode;
            UIPublicationAction publicationAction = (UIPublicationAction)((Object)event.getSource());
            UIPublicationPages publicationPages = (UIPublicationPages)publicationAction.getAncestorOfType(UIPublicationPages.class);
            UIApplication application = (UIApplication)publicationAction.getAncestorOfType(UIApplication.class);
            UIPortalNavigationExplorer portalNavigationExplorer = (UIPortalNavigationExplorer)publicationPages.getChild(UIPortalNavigationExplorer.class);
            UIPublicationTree.TreeNode selectedNode = portalNavigationExplorer.getSelectedNode();
            if (selectedNode == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.none", null, 1));
                return;
            }
            String selectedNavigationNodeURI = selectedNode.getUri();
            Node node = publicationPages.getNode();
            if (node.hasProperty("publication:navigationNodeURIs") && PublicationUtil.isNodeContentPublishedToPageNode((Node)node, (String)selectedNavigationNodeURI)) {
                Value[] navigationNodeURIs;
                for (Value navigationNodeURI : navigationNodeURIs = node.getProperty("publication:navigationNodeURIs").getValues()) {
                    if (!navigationNodeURI.getString().equals(selectedNavigationNodeURI)) continue;
                    application.addMessage(new ApplicationMessage("UIPublicationAction.msg.duplicate", null, 1));
                    return;
                }
            }
            if ((userNode = selectedNode.getUserNode()) == null) {
                application.addMessage(new ApplicationMessage("UIPublicationAction.msg.wrongNode", null, 1));
                return;
            }
            UIPublicationPagesContainer publicationPagesContainer = (UIPublicationPagesContainer)publicationPages.getAncestorOfType(UIPublicationPagesContainer.class);
            publicationAction.updateUI();
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationAction.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPagesContainer, event.getRequestContext());
        }
    }
}

