/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.job;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class TrashCleanerJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(TrashCleanerJob.class);
    public static final String EXO_AUDIT = "exo:audit";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String timeLimit = System.getProperty("exo.trashcleaner.lifetime");
        if (timeLimit == null) {
            timeLimit = "30";
        }
        LOG.info((Object)("Start TrashCleanerJob, delete nodes in trash older than " + timeLimit + " days."));
        TrashService trashService = (TrashService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TrashService.class);
        Node trashNode = trashService.getTrashHomeNode();
        int deletedNode = this.processDelete(timeLimit, trashNode);
        LOG.info((Object)("Empty Trash folder successfully! " + deletedNode + " nodes deleted"));
    }

    private int processDelete(String timeLimit, Node trashNode) {
        int deletedNode = 0;
        try {
            if (trashNode.hasNodes()) {
                NodeIterator childNodes = trashNode.getNodes();
                long size = childNodes.getSize();
                int current = 0;
                ArrayList<Node> reversedListNodes = new ArrayList<Node>();
                while (childNodes.hasNext()) {
                    Node currentNode = (Node)childNodes.next();
                    reversedListNodes.add(0, currentNode);
                }
                for (Node currentNode : reversedListNodes) {
                    if (!currentNode.getSession().isLive()) {
                        currentNode.getSession().refresh(false);
                    }
                    try {
                        if (++current % 50 == 0) {
                            LOG.info((Object)("Checking node " + currentNode.getName() + " node from Trash (" + current + "/" + size + ")"));
                        } else {
                            LOG.debug((Object)("Checking node " + currentNode.getName() + " node from Trash (" + current + "/" + size + ")"));
                        }
                        if (currentNode.getName().equals("exo:actions") && currentNode.hasNode("trashFolder")) continue;
                        if (currentNode.hasProperty("exo:lastModifiedDate")) {
                            long dateCreated = currentNode.getProperty("exo:lastModifiedDate").getDate().getTimeInMillis();
                            if (Calendar.getInstance().getTimeInMillis() - dateCreated <= Long.parseLong(timeLimit) * 24L * 60L * 60L * 1000L || !currentNode.isNodeType("exo:restoreLocation")) continue;
                            this.recursiveDelete(currentNode);
                            ++deletedNode;
                            continue;
                        }
                        this.recursiveDelete(currentNode);
                        ++deletedNode;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Error while removing " + currentNode.getName() + " node from Trash"), (Throwable)ex);
                    }
                }
            }
        }
        catch (RepositoryException ex) {
            LOG.error((Object)"Failed to get child nodes", (Throwable)ex);
        }
        return deletedNode;
    }

    public void recursiveDelete(Node node) throws Exception {
        if (node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured")) {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                this.recursiveDelete(child);
            }
        }
        this.deleteNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(Node node) throws Exception {
        ActionServiceContainer actionService = (ActionServiceContainer)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActionServiceContainer.class);
        ThumbnailService thumbnailService = (ThumbnailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThumbnailService.class);
        RepositoryService repoService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        SessionProvider sessionProviderForDeleteNode = SessionProvider.createSystemProvider();
        Session sessionForDeleteNode = sessionProviderForDeleteNode.getSession("collaboration", repoService.getDefaultRepository());
        LOG.debug("Try to delete node {}", new Object[]{node.getPath()});
        try {
            Node nodeToDelete = this.readNodeWithNewSession(node, sessionForDeleteNode);
            this.removeReferences(nodeToDelete);
            this.removeActions(actionService, repoService, nodeToDelete);
            this.removeThumbNails(thumbnailService, nodeToDelete);
            this.removeAuditForNode(nodeToDelete, repoService.getCurrentRepository());
            nodeToDelete.remove();
            nodeToDelete.getSession().save();
            LOG.debug((Object)("Node " + nodeToDelete.getPath() + " deleted"));
        }
        catch (ReferentialIntegrityException ref) {
            if (!this.fixReferentialIntegrityException(node)) {
                LOG.error((Object)("ReferentialIntegrityException when removing " + node.getName() + " node from Trash"), (Throwable)ref);
            }
        }
        catch (ConstraintViolationException cons) {
            LOG.error((Object)("ConstraintViolationException when removing " + node.getName() + " node from Trash"), (Throwable)cons);
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while removing " + node.getName() + " node from Trash"), (Throwable)ex);
        }
        finally {
            sessionForDeleteNode.logout();
            sessionProviderForDeleteNode.close();
        }
    }

    private void removeThumbNails(ThumbnailService thumbnailService, Node nodeToDelete) {
        String nodePath = "";
        try {
            nodePath = nodeToDelete.getPath();
            thumbnailService.processRemoveThumbnail(nodeToDelete);
        }
        catch (Exception ex) {
            LOG.error("An error occurs while removing thumbnail for node {} ", new Object[]{nodePath, ex});
        }
    }

    private void removeActions(ActionServiceContainer actionService, RepositoryService repoService, Node nodeToDelete) {
        String nodePath = "";
        try {
            nodePath = nodeToDelete.getPath();
            actionService.removeAction(nodeToDelete, repoService.getCurrentRepository().getConfiguration().getName());
        }
        catch (Exception ex) {
            LOG.error("An error occurs while removing actions related to node {} ", new Object[]{nodePath, ex});
        }
    }

    private boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private boolean fixReferentialIntegrityException(Node node) {
        String name = "";
        try {
            Session session = node.getSession();
            session.refresh(false);
            name = node.getName();
            boolean shouldDeleteNode = false;
            String liveRevision = node.getProperty("publication:liveRevision").getValue().getString();
            Node versionHistory = session.getNodeByUUID(liveRevision).getParent();
            NodeIterator it = versionHistory.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                long nbRef = child.getReferences().getSize();
                LOG.debug("Version history child node {} have {} references", new Object[]{child.getPath(), nbRef});
                PropertyIterator iter = child.getReferences();
                while (iter.hasNext()) {
                    String relationPath = iter.nextProperty().getPath();
                    LOG.debug((Object)("Node " + child.getPath() + " is referenced by " + relationPath));
                    if (relationPath.startsWith(node.getPath())) continue;
                    Node relation = node.getSession().getItem(relationPath).getParent();
                    this.cleanPublication(relation);
                    shouldDeleteNode = true;
                }
            }
            if (shouldDeleteNode) {
                this.deleteNode(node);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while removing (without the version history) " + name + " node from Trash"), (Throwable)e);
        }
        return false;
    }

    private void cleanPublication(Node relation) {
        String name = "";
        try {
            name = relation.getName();
            relation.setProperty("publication:liveRevision", (Value)null);
            relation.setProperty("publication:currentState", "published");
            relation.save();
            LOG.info("Publication cleaned on node {}, to fix integrity problem.", new Object[]{name});
        }
        catch (Exception e) {
            LOG.error("Unable to clean publication for node {}", new Object[]{name, e});
        }
    }

    private Node readNodeWithNewSession(Node node, Session sessionForDeleteNode) throws RepositoryException {
        String idf = ((NodeImpl)node).getIdentifier();
        return ((SessionImpl)sessionForDeleteNode).getNodeByIdentifier(idf);
    }

    private void removeReferences(Node node) {
        String nodePath = "";
        try {
            nodePath = node.getPath();
            RelationsService relationService = (RelationsService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationsService.class);
            PropertyIterator iter = node.getReferences();
            if (iter.hasNext()) {
                String relationPath = iter.nextProperty().getPath();
                LOG.debug((Object)("Node " + node.getPath() + " is referenced by " + relationPath + ", remove the referenec"));
                Item relation = node.getSession().getItem(relationPath);
                Node sourceRelationNode = relation.getParent();
                relationService.removeRelation(sourceRelationNode, node.getPath());
            }
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                this.removeReferences(child);
            }
        }
        catch (Exception ex) {
            LOG.error("An error occurs while removing relations for node {}", new Object[]{nodePath, ex});
        }
    }

    private void removeAuditForNode(Node node, ManageableRepository repository) {
        String nodePath = "";
        try {
            Session session;
            nodePath = node.getPath();
            if (this.checkPermission(node, "remove") && node.isNodeType("exo:auditable") && (session = SessionProvider.createSystemProvider().getSession(node.getSession().getWorkspace().getName(), repository)).getRootNode().hasNode(EXO_AUDIT) && session.getRootNode().getNode(EXO_AUDIT).hasNode(node.getUUID())) {
                session.getRootNode().getNode(EXO_AUDIT).getNode(node.getUUID()).remove();
                session.save();
            }
        }
        catch (Exception ex) {
            LOG.error("An error occurs while removing audit for node {}", new Object[]{nodePath, ex});
        }
    }
}

