/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions.postscript;

import java.util.HashMap;
import java.util.Stack;
import org.icepdf.core.pobjects.functions.postscript.Expression;
import org.icepdf.core.pobjects.functions.postscript.Operator;
import org.icepdf.core.pobjects.functions.postscript.OperatorNames;
import org.icepdf.core.pobjects.functions.postscript.Procedure;

public class OperatorFactory {
    private static HashMap<Integer, Operator> operatorCache = new HashMap();

    public static Operator getOperator(char[] ch, int offset, int length) {
        final int operatorType = OperatorNames.getType(ch, offset, length);
        Operator operator = operatorCache.get(operatorType);
        if (operator != null) {
            return operator;
        }
        switch (operatorType) {
            case 1: {
                operator = new Operator(1){

                    public void eval(Stack stack) {
                        Float num = (Float)stack.pop();
                        stack.push(Float.valueOf(Math.abs(num.floatValue())));
                    }
                };
                break;
            }
            case 2: {
                operator = new Operator(2){

                    public void eval(Stack stack) {
                        Float num2 = (Float)stack.pop();
                        Float num1 = (Float)stack.pop();
                        stack.push(Float.valueOf(num1.floatValue() + num2.floatValue()));
                    }
                };
                break;
            }
            case 3: {
                operator = new Operator(3){

                    public void eval(Stack stack) {
                        Object value = stack.pop();
                        if (value instanceof Boolean) {
                            boolean bool2 = (Boolean)value;
                            boolean bool1 = (Boolean)stack.pop();
                            stack.push(bool1 && bool2);
                        } else {
                            int val1 = ((Float)value).intValue();
                            int val2 = ((Float)stack.pop()).intValue();
                            stack.push(val1 & val2);
                        }
                    }
                };
                break;
            }
            case 4: {
                operator = new Operator(4){

                    public void eval(Stack stack) {
                        float den = ((Float)stack.pop()).floatValue();
                        float num = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.toDegrees(Math.atan(num / den))).floatValue()));
                    }
                };
                break;
            }
            case 5: {
                operator = new Operator(5){

                    public void eval(Stack stack) {
                        long shift = (Long)stack.pop();
                        long int1 = (Long)stack.pop();
                        stack.push(int1 << (int)shift);
                    }
                };
                break;
            }
            case 6: {
                operator = new Operator(6){

                    public void eval(Stack stack) {
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.ceil(num1)).floatValue()));
                    }
                };
                break;
            }
            case 7: {
                operator = new Operator(7){

                    public void eval(Stack stack) {
                        float aAngle = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.cos(aAngle)).floatValue()));
                    }
                };
                break;
            }
            case 8: {
                operator = new Operator(8){

                    public void eval(Stack stack) {
                        int n = ((Float)stack.pop()).intValue();
                        int top = stack.size();
                        for (int i = top - n; i < top; ++i) {
                            stack.push(stack.get(i));
                        }
                    }
                };
                break;
            }
            case 9: {
                operator = new Operator(9){

                    public void eval(Stack stack) {
                        int number = ((Float)stack.pop()).intValue();
                        stack.push(number);
                    }
                };
                break;
            }
            case 10: {
                operator = new Operator(10){

                    public void eval(Stack stack) {
                        float number = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(number));
                    }
                };
                break;
            }
            case 11: {
                operator = new Operator(11){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(num1 / num2));
                    }
                };
                break;
            }
            case 12: {
                operator = new Operator(12){

                    public void eval(Stack stack) {
                        stack.push(stack.peek());
                    }
                };
                break;
            }
            case 13: {
                operator = new Operator(13){

                    public void eval(Stack stack) {
                        Object any2 = stack.pop();
                        Object any1 = stack.pop();
                        stack.push(any1.equals(any2));
                    }
                };
                break;
            }
            case 14: {
                operator = new Operator(14){

                    public void eval(Stack stack) {
                        Object any2 = stack.pop();
                        Object any1 = stack.pop();
                        stack.push(any2);
                        stack.push(any1);
                    }
                };
                break;
            }
            case 15: {
                operator = new Operator(15){

                    public void eval(Stack stack) {
                        float exponent = ((Float)stack.pop()).floatValue();
                        float base = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.pow(base, exponent)).floatValue()));
                    }
                };
                break;
            }
            case 17: {
                operator = new Operator(17){

                    public void eval(Stack stack) {
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.floor(num1)).floatValue()));
                    }
                };
                break;
            }
            case 18: {
                operator = new Operator(18){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(num1 >= num2);
                    }
                };
                break;
            }
            case 19: {
                operator = new Operator(19){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(num1 > num2);
                    }
                };
                break;
            }
            case 20: {
                operator = new Operator(20){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push((int)(num1 / num2));
                    }
                };
                break;
            }
            case 21: {
                operator = new Operator(21){

                    public void eval(Stack stack) {
                        boolean bool;
                        Procedure proc1 = null;
                        if (stack.peek() instanceof Procedure) {
                            proc1 = (Procedure)stack.pop();
                        }
                        if (bool = ((Boolean)stack.pop()).booleanValue()) {
                            proc1.eval(stack);
                        }
                    }
                };
                break;
            }
            case 22: {
                operator = new Operator(22){

                    public void eval(Stack stack) {
                        boolean bool;
                        Procedure proc2 = null;
                        Procedure proc1 = null;
                        if (stack.peek() instanceof Procedure) {
                            proc2 = (Procedure)stack.pop();
                        }
                        if (stack.peek() instanceof Procedure) {
                            proc1 = (Procedure)stack.pop();
                        }
                        if (bool = ((Boolean)stack.pop()).booleanValue()) {
                            proc1.eval(stack);
                        } else {
                            proc2.eval(stack);
                        }
                    }
                };
                break;
            }
            case 24: {
                operator = new Operator(24){

                    public void eval(Stack stack) {
                        float n = ((Float)stack.pop()).floatValue();
                        stack.push(stack.get((int)((float)(stack.size() - 1) - n)));
                    }
                };
                break;
            }
            case 25: {
                operator = new Operator(25){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(num1 <= num2);
                    }
                };
                break;
            }
            case 23: {
                operator = new Operator(23){

                    public void eval(Stack stack) {
                        float num = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.log(num)).floatValue()));
                    }
                };
                break;
            }
            case 26: {
                operator = new Operator(26){

                    public void eval(Stack stack) {
                        float num = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.log10(num)).floatValue()));
                    }
                };
                break;
            }
            case 27: {
                operator = new Operator(27){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(num1 < num2);
                    }
                };
                break;
            }
            case 28: {
                operator = new Operator(28){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(num1 % num2));
                    }
                };
                break;
            }
            case 29: {
                operator = new Operator(29){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(num1 * num2));
                    }
                };
                break;
            }
            case 30: {
                operator = new Operator(30){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(num1 != num2);
                    }
                };
                break;
            }
            case 31: {
                operator = new Operator(31){

                    public void eval(Stack stack) {
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(-num1));
                    }
                };
                break;
            }
            case 32: {
                operator = new Operator(32){

                    public void eval(Stack stack) {
                        boolean num1 = (Boolean)stack.pop();
                        stack.push(!num1);
                    }
                };
                break;
            }
            case 33: {
                operator = new Operator(33){

                    public void eval(Stack stack) {
                        boolean bool2 = (Boolean)stack.pop();
                        boolean bool1 = (Boolean)stack.pop();
                        stack.push(bool1 || bool2);
                    }
                };
                break;
            }
            case 34: {
                operator = new Operator(34){

                    public void eval(Stack stack) {
                        stack.pop();
                    }
                };
                break;
            }
            case 35: {
                operator = new Operator(35){

                    public void eval(Stack stack) {
                        block3: {
                            float n;
                            float j;
                            block2: {
                                j = ((Float)stack.pop()).floatValue();
                                n = ((Float)stack.pop()).floatValue();
                                if (!(j > 0.0f)) break block2;
                                int i = 0;
                                while ((float)i < j) {
                                    stack.insertElementAt(stack.lastElement(), (int)((float)stack.size() - n));
                                    stack.pop();
                                    ++i;
                                }
                                break block3;
                            }
                            if (!(j < 0.0f)) break block3;
                            int max = (int)(-j);
                            for (int i = 0; i < max; ++i) {
                                stack.push(stack.remove((int)((float)stack.size() - n)));
                            }
                        }
                    }
                };
                break;
            }
            case 36: {
                operator = new Operator(36){

                    public void eval(Stack stack) {
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.round(num1)).floatValue()));
                    }
                };
                break;
            }
            case 37: {
                operator = new Operator(37){

                    public void eval(Stack stack) {
                        float aAngle = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.sin(aAngle)).floatValue()));
                    }
                };
                break;
            }
            case 38: {
                operator = new Operator(38){

                    public void eval(Stack stack) {
                        float num = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.sqrt(num)).floatValue()));
                    }
                };
                break;
            }
            case 39: {
                operator = new Operator(39){

                    public void eval(Stack stack) {
                        float num2 = ((Float)stack.pop()).floatValue();
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(num1 - num2));
                    }
                };
                break;
            }
            case 41: {
                operator = new Operator(41){

                    public void eval(Stack stack) {
                        float num1 = ((Float)stack.pop()).floatValue();
                        stack.push(Float.valueOf(((Number)Math.floor(num1)).floatValue()));
                    }
                };
                break;
            }
            case 42: {
                operator = new Operator(42){

                    public void eval(Stack stack) {
                        Object obj2 = stack.pop();
                        if (obj2 instanceof Number) {
                            float num2 = ((Float)obj2).floatValue();
                            float num1 = ((Float)stack.pop()).floatValue();
                            stack.push((int)num1 ^ (int)num2);
                        } else if (obj2 instanceof Boolean) {
                            boolean bool2 = (Boolean)obj2;
                            boolean bool1 = (Boolean)stack.pop();
                            stack.push(bool1 ^ bool2);
                        }
                    }
                };
                break;
            }
            case 43: {
                operator = new Expression(43);
                break;
            }
            case 44: {
                operator = new Expression(44);
                break;
            }
            default: {
                operator = new Operator(0){

                    public void eval(Stack stack) {
                        System.out.println(operatorType + " not implemented ");
                    }
                };
            }
        }
        if (operator != null) {
            operatorCache.put(operator.getType(), operator);
        }
        return operator;
    }
}

