/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class Utils {
    public static final String WORKSPACE_NAME = "workspace";
    public static final String JCR_PATH = "path";
    public static final String DRIVE_FOLDER = "allowCreateFolder";
    public static final String MIN_WIDTH = "minwidth";
    public static final String CB_DOCUMENT_NAME = "documentName";
    public static final String CB_SCRIPT_NAME = "scriptName";
    public static final String CB_REF_DOCUMENT = "reference";
    public static final String CB_CHILD_DOCUMENT = "child";
    public static final String CB_NB_PER_PAGE = "nbPerPage";
    public static final String CB_QUERY_STATEMENT = "queryStatement";
    public static final String CB_QUERY_ISNEW = "isAddNew";
    public static final String CB_QUERY_TYPE = "queryType";
    public static final String CB_QUERY_STORE = "queryStore";
    public static final String CB_QUERY_LANGUAGE = "queryLanguage";
    public static final String CB_VIEW_TOOLBAR = "viewToolbar";
    public static final String CB_VIEW_TAGMAP = "viewTagMap";
    public static final String CB_VIEW_COMMENT = "viewComment";
    public static final String CB_VIEW_VOTE = "viewVote";
    public static final String CB_SEARCH_LOCATION = "searchLocation";
    public static final String CB_ENABLE_SEARCH_LOCATION = "enableSearch";
    public static final String CB_FILTER_CATEGORY = "filterCategory";
    public static final String EXO_AUDITABLE = "exo:auditable";
    public static final String CB_BOX_TEMPLATE = "boxTemplate";
    public static final String CB_TEMPLATE = "template";
    public static final String CB_USECASE = "usecase";
    public static final String CB_ALLOW_PUBLISH = "isAllowPublish";
    public static final String FROM_PATH = "From Path";
    public static final String USE_DOCUMENT = "Document";
    public static final String USE_JCR_QUERY = "Using a JCR query";
    public static final String USE_SCRIPT = "Using a script";
    public static final String CB_USE_FROM_PATH = "path";
    public static final String CB_USE_DOCUMENT = "detail-document";
    public static final String CB_USE_JCR_QUERY = "query";
    public static final String CB_USE_SCRIPT = "script";
    public static final String SEMI_COLON = ";";
    public static final String COLON = ":";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EXO_CREATED_DATE = "exo:dateCreated";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFIED_DATE = "exo:dateModified";
    public static final String EXO_OWNER = "exo:owner";
    public static final String[] SPECIALCHARACTER = new String[]{";", "/", "\\", "|", ">", "<", "\"", "?", "!", "#", "$", "&", "*", "(", ")", "{", "}", "[", "]", ":", ".", "'"};
    public static final String REPOSITORY = "repository";
    public static final String VIEWS = "views";
    public static final String DRIVE = "drive";
    public static final String TRASH_HOME_NODE_PATH = "trashHomeNodePath";
    public static final String TRASH_REPOSITORY = "trashRepository";
    public static final String TRASH_WORKSPACE = "trashWorkspace";
    public static final String JCR_INFO = "jcrInfo";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FROZEN = "nt:frozenNode";
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_RELATION = "exo:relation";
    public static final String EXO_TAXONOMY = "exo:taxonomy";
    public static final String EXO_IMAGE = "exo:image";
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String LANGUAGES = "languages";
    public static final String EXO_METADATA = "exo:metadata";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_BASE = "nt:base";
    public static final String DEFAULT = "default";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_CONTENT_DESCRIPTION = "jcr:content/dc:description";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_FROZEN = "jcr:frozenNode";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String EXO_ROLES = "exo:roles";
    public static final String EXO_TEMPLATEFILE = "exo:templateFile";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ACTION = "exo:action";
    public static final String EXO_ACTIONS = "exo:actions";
    public static final String MIX_LOCKABLE = "mix:lockable";
    public static final String EXO_CATEGORIZED = "exo:categorized";
    public static final String EXO_CATEGORY = "exo:category";
    public static final String EXO_HIDDENABLE = "exo:hiddenable";
    public static final String EXO_ACCESSPERMISSION = "exo:accessPermissions";
    public static final String EXO_PERMISSIONS = "exo:permissions";
    public static final String EXO_FAVOURITE = "exo:favourite";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String EXO_FAVOURITER = "exo:favouriter";
    public static final String EXO_RESTOREPATH = "exo:restorePath";
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    public static final String EXO_RESTORE_WORKSPACE = "exo:restoreWorkspace";
    public static final String EXO_LASTMODIFIER = "exo:lastModifier";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_TOTAL = "exo:total";
    public static final String EXO_WEBCONTENT = "exo:webContent";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String EXO_COMMENTS = "exo:comments";
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String MIX_COMMENTABLE = "mix:commentable";
    public static final String MIX_VOTABLE = "mix:votable";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String INLINE_DRAFT = "Draft";
    public static final String INLINE_PUBLISHED = "Published";
    public static final String EXO_SORTABLE = "exo:sortable";
    public static final String EXO_RISIZEABLE = "exo:documentSize";
    public static final String FLASH_MIMETYPE = "flash";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    public static final String[] FOLDERS = new String[]{"nt:unstructured", "nt:folder"};
    public static final String[] NON_EDITABLE_NODETYPES = new String[]{"nt:unstructured", "nt:folder", "nt:resource"};
    public static final String[] CATEGORY_NODE_TYPES = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String UPLOAD_SIZE_LIMIT_MB = "uploadFileSizeLimitMB";
    public static final String FILE_VIEWER_EXTENSION_TYPE = "org.exoplatform.ecm.dms.FileViewer";
    public static final String MIME_TYPE = "mimeType";
    public static final String REQUESTCONTEXT = "requestcontext";
    public static final String WORKSPACE_PARAM = "workspaceName";
    public static final String SPACE_GROUP = "/spaces";
    public static final String SITES_PATH = "/sites";
    public static final String COLLABORATION_WS = "collaboration";
    public static final int USER_DEPTH = 5;
    public static final String EMPTY = "";
    public static final String PUBLIC = "Public";
    public static final String GROUP = "Group";
    public static final String SITE = "Site";
    public static final String PRIVATE = "Private";
    public static final String URL_BACKTO = "backto";
    public static final String INPUT_TEXT_AREA = "TEXTAREA";
    public static final String INPUT_WYSIWYG = "WYSIWYG";
    public static final String INPUT_TEXT = "TEXT";
    public static final String DEFAULT_CSS_NAME = "InlineText";
    public static final String LEFT2RIGHT = "left-to-right";
    public static final String RIGHT2LEFT = "right-to-left";
    protected static final String SEPARATOR = "=";
    protected static final String TOOLBAR = "toolbar";
    protected static final String CSS = "CSSData";
    protected static final String HEIGHT = "height";
    protected static final String BUTTON_DIR = "button_direction";
    protected static final String PREV_HTML = "prev_html";
    protected static final String POST_HTML = "post_html";
    protected static final String FAST_PUBLISH_LINK = "fast_publish";
    private static final Log LOG = ExoLogger.getLogger((String)Utils.class.getName());

    public static String encodeHTML(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatNodeName(String text) {
        return text.replaceAll("('|\")", "\\\\'");
    }

    public static boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_VERSIONABLE);
    }

    public static boolean isTrashHomeNode(Node node) throws RepositoryException {
        return node.isNodeType(EXO_TRASH_FOLDER);
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static boolean targetNodeAndLinkInTrash(Node currentNode) throws Exception {
        Node targetNode;
        return Utils.isInTrash(currentNode) && Utils.isSymLink(currentNode) && Utils.isInTrash(targetNode = Utils.getNodeSymLink(currentNode));
    }

    public static boolean isAbleToRestore(Node currentNode) throws Exception {
        Node restoreLocationNode;
        if (!Utils.isInTrash(currentNode)) {
            return false;
        }
        if (EXO_ACTIONS.equals(currentNode.getName()) && Utils.isInTrash(currentNode)) {
            return false;
        }
        if (Utils.targetNodeAndLinkInTrash(currentNode)) {
            return false;
        }
        if (ConversationState.getCurrent().getIdentity().getUserId().equalsIgnoreCase(WCMCoreUtils.getSuperUser())) {
            return true;
        }
        if (!currentNode.isNodeType(EXO_RESTORELOCATION)) {
            return false;
        }
        String restorePath = currentNode.getProperty(EXO_RESTOREPATH).getString();
        String restoreWorkspace = currentNode.getProperty(EXO_RESTORE_WORKSPACE).getString();
        restorePath = restorePath.substring(0, restorePath.lastIndexOf(SLASH));
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(restoreWorkspace, WCMCoreUtils.getRepository());
        try {
            restoreLocationNode = restorePath == null || restorePath.length() == 0 ? session.getRootNode() : (Node)session.getItem(restorePath);
        }
        catch (Exception e) {
            return false;
        }
        return PermissionUtil.canAddNode(restoreLocationNode);
    }

    public static boolean isReferenceable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_REFERENCEABLE);
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (name != null && !name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static boolean isAuditable(Node node) throws RepositoryException {
        return node.isNodeType(EXO_AUDITABLE);
    }

    public static String getIndexName(Node node) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(node.getName());
        int index = node.getIndex();
        if (index > 1) {
            buffer.append('[');
            buffer.append(index);
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        return org.exoplatform.services.cms.impl.Utils.getNodeTypeIcon(node, appended, mode);
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return org.exoplatform.services.cms.impl.Utils.getNodeTypeIcon(node, appended);
    }

    public static NodeIterator getAuthorizedChildNodes(Node node) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (PermissionUtil.canRead(iter.nextNode())) continue;
            iter.remove();
        }
        return iter;
    }

    public static List<Node> getAuthorizedChildList(Node node) throws Exception {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!PermissionUtil.canRead(child)) continue;
            children.add(child);
        }
        return children;
    }

    public static boolean isLockTokenHolder(Node node) throws Exception {
        return node.getLock().getLockToken() != null;
    }

    public static List<String> getMemberships() throws Exception {
        return org.exoplatform.services.cms.impl.Utils.getMemberships();
    }

    public static List<String> getGroups() throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        Set groups = identity.getGroups();
        return new ArrayList<String>(groups);
    }

    public static String getNodeOwner(Node node) throws Exception {
        try {
            if (node.hasProperty(EXO_OWNER)) {
                return node.getProperty(EXO_OWNER).getString();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Node findNodeByUUID(String uuid) throws Exception {
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getService(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Node node = null;
        for (String wsName : manageableRepository.getWorkspaceNames()) {
            try {
                node = sessionProvider.getSession(wsName, manageableRepository).getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)ExoContainerContext.getService(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public static Node getNodeSymLink(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)ExoContainerContext.getService(LinkManager.class);
        Node realNode = null;
        if (linkManager.isLink((Item)node)) {
            if (linkManager.isTargetReachable(node)) {
                realNode = linkManager.getTarget(node);
            }
        } else {
            realNode = node;
        }
        return realNode;
    }

    public static InputStream extractFirstEntryFromZipFile(ZipInputStream zipStream) throws Exception {
        return zipStream.getNextEntry() == null ? null : zipStream;
    }

    public static String getThumbnailImage(InputStream input, String downloadName) throws Exception {
        DownloadService dservice = WCMCoreUtils.getService(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(downloadName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public static String getThumbnailImage(Node node, String propertyName) throws Exception {
        Node thumbnailNode;
        String mimeType;
        ThumbnailService thumbnailService = (ThumbnailService)ExoContainerContext.getService(ThumbnailService.class);
        if (node.isNodeType(NT_FILE) && (mimeType = node.getNode(JCR_CONTENT).getProperty(JCR_MIMETYPE).getString()).startsWith("image")) {
            Node thumbnailNode2 = thumbnailService.addThumbnailNode(node);
            InputStream inputStream = node.getNode(JCR_CONTENT).getProperty(JCR_DATA).getStream();
            thumbnailService.createSpecifiedThumbnail(thumbnailNode2, ImageIO.read(inputStream), propertyName);
        }
        if ((thumbnailNode = thumbnailService.getThumbnailNode(node)) != null && thumbnailNode.hasProperty(propertyName)) {
            DownloadService dservice = (DownloadService)ExoContainerContext.getService(DownloadService.class);
            InputStream input = thumbnailNode.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static String calculateFileSize(double fileLengthLong) {
        int fileLengthDigitCount = Double.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = EMPTY;
        if (fileLengthDigitCount < 5) {
            fileSizeKB = Math.abs(fileLengthLong);
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 5 && fileLengthDigitCount <= 6) {
            fileSizeKB = Math.abs(fileLengthLong / 1024.0);
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1048576.0);
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1.073741824E9);
            howBig = "GB";
        }
        String finalResult = Utils.roundTwoDecimals(fileSizeKB);
        return finalResult + " " + howBig;
    }

    private static String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(d);
    }

    public static String getRestContextName(String portalContainerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(portalContainerName);
    }

    public static String getTitle(Node node) throws Exception {
        String title = null;
        try {
            title = node.getProperty(EXO_TITLE).getValue().getString();
        }
        catch (PathNotFoundException pnf1) {
            try {
                Value[] values = node.getNode(JCR_CONTENT).getProperty("dc:title").getValues();
                if (values.length != 0) {
                    title = values[0].getString();
                }
            }
            catch (PathNotFoundException pnf2) {
                title = null;
            }
        }
        catch (IllegalStateException | RepositoryException e) {
            title = null;
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            title = node.getName();
        }
        int index = node.getIndex();
        StringBuilder buffer = new StringBuilder(128);
        if (index > 1) {
            buffer.append(title);
            buffer.append('[');
            buffer.append(index);
            buffer.append(']');
            title = buffer.toString();
        }
        try {
            title = URLDecoder.decode(title, "UTF-8");
            return URLDecoder.decode(title, "UTF-8");
        }
        catch (Exception e) {
            return title;
        }
    }

    public static String getName(Node node) throws Exception {
        String name = null;
        try {
            name = node.getProperty("exo:name").getValue().getString();
        }
        catch (PathNotFoundException pnf1) {
            try {
                Value[] values = node.getNode(JCR_CONTENT).getProperty("dc:name").getValues();
                if (values.length != 0) {
                    name = values[0].getString();
                }
            }
            catch (PathNotFoundException pnf2) {
                name = null;
            }
        }
        catch (IllegalStateException | RepositoryException e) {
            name = null;
        }
        return URLDecoder.decode(name, "UTF-8");
    }

    public static boolean isMakeVersionable(Node node, String[] nodeTypes) throws Exception {
        String ws = node.getSession().getWorkspace().getName();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        Session session = sessionProvider.getSession(ws, manageableRepository);
        node = (Node)session.getItem(node.getPath());
        int deep = node.getDepth();
        for (int i = 0; i < deep; ++i) {
            Node parent = node.getParent();
            for (String nodeType : nodeTypes) {
                if (nodeType == null || nodeType.length() <= 0 || !parent.isNodeType(nodeType)) continue;
                return false;
            }
            node = parent;
        }
        return true;
    }

    public static String getDownloadRestServiceLink(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        String portalName = containerInfo.getContainerName();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        String restContextName = portalContainerConfig.getRestContextName(portalName);
        StringBuilder sb = new StringBuilder();
        Node currentNode = Utils.getRealNode(node);
        String ndPath = currentNode.getPath();
        if (ndPath.startsWith(SLASH)) {
            ndPath = ndPath.substring(1);
        }
        String encodedPath = Utils.encodePath(ndPath, "UTF-8");
        sb.append(SLASH).append(restContextName).append("/contents/download/");
        sb.append(currentNode.getSession().getWorkspace().getName()).append(SLASH).append(encodedPath);
        if (node.isNodeType(NT_FROZEN)) {
            sb.append("?version=" + node.getParent().getName());
        }
        return sb.toString();
    }

    public static String getPDFViewerLink(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        String portalName = containerInfo.getContainerName();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        String restContextName = portalContainerConfig.getRestContextName(portalName);
        StringBuilder sb = new StringBuilder();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        sb.append(SLASH).append(restContextName).append("/pdfviewer/");
        sb.append(repository).append(SLASH);
        sb.append(node.getSession().getWorkspace().getName()).append(SLASH).append(node.getUUID());
        return sb.toString();
    }

    public static List<String> getAllowedFolderTypesInCurrentPath(Node currentNode, DriveData currentDrive) throws Exception {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        NodeTypeImpl currentNodeType = (NodeTypeImpl)currentNode.getPrimaryNodeType();
        String[] arrFoldertypes = currentDrive.getAllowCreateFolders().split(",");
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        for (String strFolderType : arrFoldertypes) {
            NodeType folderType;
            if (strFolderType.isEmpty() || !currentNodeType.isChildNodePrimaryTypeAllowed(Constants.JCR_ANY_NAME, ((NodeTypeImpl)(folderType = ntManager.getNodeType(strFolderType))).getQName())) continue;
            allowedTypes.add(strFolderType);
        }
        return allowedTypes;
    }

    public static String[] removeChildNodes(String srcPath) {
        if (StringUtils.isEmpty((CharSequence)srcPath)) {
            return new String[0];
        }
        if (!srcPath.contains(SEMI_COLON)) {
            return new String[]{srcPath};
        }
        String[] paths = srcPath.split(SEMI_COLON);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            boolean ok = true;
            for (int j = 0; j < paths.length; ++j) {
                if (i == j || !paths[i].startsWith(paths[j]) || paths[i].length() <= paths[j].length() || paths[i].charAt(paths[j].length()) != '/') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            ret.add(paths[i]);
        }
        return ret.toArray(new String[0]);
    }

    public static String encodePath(String path, String encoding) {
        try {
            String encodedPath = URLEncoder.encode(path, encoding);
            encodedPath = encodedPath.replaceAll("%2F", SLASH);
            return encodedPath;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Failed to encode path '" + path + "' with encoding '" + encoding + "'"), (Throwable)e);
            return null;
        }
    }

    public static String generateMountURL(String nodePath, String ws, String userPath, String groupPath) {
        if (StringUtils.isNotBlank((CharSequence)nodePath) && COLLABORATION_WS.equals(ws)) {
            StringBuilder mountPath = new StringBuilder();
            String[] ancestors = nodePath.substring(1).split(SLASH);
            if (ancestors.length <= 1) {
                return SLASH;
            }
            if (nodePath.startsWith(userPath)) {
                if (ancestors.length >= 6) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[6]) - 1));
                } else {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[ancestors.length - 1]) - 1));
                }
            } else if (nodePath.startsWith(groupPath + SPACE_GROUP)) {
                if (ancestors.length > 4) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[4]) - 1));
                } else if (ancestors.length == 4) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[3]) - 1));
                } else {
                    mountPath.append(groupPath + SPACE_GROUP);
                }
            } else if (nodePath.startsWith(groupPath)) {
                if (ancestors.length > 2) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[2]) - 1));
                } else {
                    mountPath.append(groupPath);
                }
            } else if (nodePath.startsWith(SITES_PATH)) {
                if (ancestors.length > 2) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[2]) - 1));
                } else {
                    mountPath.append(SITES_PATH);
                }
            } else if (ancestors.length > 4) {
                mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[3]) - 1));
            } else if (ancestors.length > 1) {
                mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[ancestors.length - 1]) - 1));
            }
            return mountPath.toString();
        }
        return SLASH;
    }

    private static String checkMountPath(Node node, String mountPath) throws AccessControlException, RepositoryException {
        NodeImpl parent = (NodeImpl)node.getParent();
        boolean hasPermission = false;
        while (PermissionUtil.canRead((Node)parent)) {
            hasPermission = true;
            if (mountPath.equals(parent.getPath()) || parent.isRoot()) break;
            parent = parent.getParent();
        }
        if (hasPermission) {
            return parent.getPath();
        }
        LOG.warn("Cannot mount webdav path {} You don't have read permission access", new Object[]{parent.getPath()});
        throw new AccessControlException("You don't have read permission access to " + parent.getPath());
    }

    public static boolean isDownloadDocumentActivated() {
        SettingService settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        SettingValue settingValue = settingService.get(Context.GLOBAL.id("downloadDocumentStatus"), Scope.APPLICATION.id("downloadDocumentStatus"), "exo:downloadDocumentStatus");
        return settingValue == null || settingValue.getValue().toString().isEmpty() || !Boolean.valueOf(settingValue.getValue().toString()).booleanValue();
    }

    public static boolean isViewable(Node node) {
        try {
            node.refresh(true);
            ((ExtendedNode)node).checkPermission("read");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Node getRealNode(Node node) throws Exception {
        if (node.isNodeType(NT_FROZEN)) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            return node.getSession().getNodeByUUID(uuid);
        }
        return node;
    }

    public static String getRealNodePath(Node node) throws Exception {
        if (node.isNodeType(NT_FROZEN)) {
            Node realNode = Utils.getRealNode(node);
            return Text.escape(realNode.getPath(), '%', true) + "?version=" + node.getParent().getName();
        }
        return Text.escape(node.getPath(), '%', true);
    }

    public static String getWebdavURL(Node node) throws Exception {
        return Utils.getWebdavURL(node, true);
    }

    public static String getWebdavURL(Node node, boolean withTimeParam) throws Exception {
        return Utils.getWebdavURL(node, withTimeParam, true);
    }

    public static String getWebdavURL(Node node, boolean withTimeParam, boolean isGetRealNodePath) throws Exception {
        NodeLocation location = NodeLocation.getNodeLocationByNode(Utils.getRealNode(node));
        String repository = location.getRepository();
        String workspace = location.getWorkspace();
        String currentProtal = PortalContainer.getCurrentRestContextName();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String originalNodePath = isGetRealNodePath ? Utils.getRealNodePath(node) : Text.escape(node.getPath(), '%', true);
        StringBuilder imagePath = new StringBuilder();
        imagePath.append(SLASH).append(portalName).append(SLASH).append(currentProtal).append("/jcr/").append(repository).append(SLASH).append(workspace).append(originalNodePath);
        if (withTimeParam) {
            if (imagePath.indexOf("?") > 0) {
                imagePath.append("&time=");
            } else {
                imagePath.append("?time=");
            }
            imagePath.append(System.currentTimeMillis());
        }
        return imagePath.toString();
    }

    public static Node getRealNode(String strRepository, String strWorkspace, String strIdentifier, boolean isWCMBase) throws RepositoryException {
        return Utils.getRealNode(strRepository, strWorkspace, strIdentifier, isWCMBase, null);
    }

    public static Node getRealNode(String strRepository, String strWorkspace, String strIdentifier, boolean isWCMBase, String cacheVisibility) throws RepositoryException {
        LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
        TrashService trashService = WCMCoreUtils.getService(TrashService.class);
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(strWorkspace, WCMCoreUtils.getService(RepositoryService.class).getRepository(strRepository));
        Node selectedNode = session.getNodeByUUID(strIdentifier);
        if (selectedNode != null && !trashService.isInTrash(selectedNode)) {
            if (linkManager.isLink((Item)selectedNode)) {
                if (linkManager.isTargetReachable(selectedNode) && !trashService.isInTrash(selectedNode = linkManager.getTarget(selectedNode))) {
                    return selectedNode;
                }
            } else {
                return selectedNode;
            }
        }
        return null;
    }

    public static String getDownloadLink(Node node) throws Exception {
        if (!Utils.getRealNode(node).isNodeType(NT_FILE)) {
            return null;
        }
        DownloadService dservice = WCMCoreUtils.getService(DownloadService.class);
        Node jcrContentNode = node.getNode(JCR_CONTENT);
        InputStream input = jcrContentNode.getProperty(JCR_DATA).getStream();
        String mimeType = jcrContentNode.getProperty(JCR_MIMETYPE).getString();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, mimeType);
        DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
        String ext = "." + mimeTypeSolver.getExtension(mimeType);
        String fileName = Utils.getRealNode(node).getName();
        if (fileName.lastIndexOf(ext) < 0 && !mimeTypeSolver.getMimeType(fileName).equals(mimeType)) {
            dresource.setDownloadName(fileName + ext);
        } else {
            dresource.setDownloadName(fileName);
        }
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public static Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.isNodeType(NT_UNSTRUCTURED) && currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.isNodeType(NT_FILE)) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public static class NodeTypeNameComparator
    implements Comparator<NodeType> {
        @Override
        public int compare(NodeType n1, NodeType n2) throws ClassCastException {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

