/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.connector.clouddrives;

import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.cms.clouddrives.CannotCreateDriveException;
import org.exoplatform.services.cms.clouddrives.CloudDrive;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.cms.clouddrives.features.CloudDriveFeatures;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/clouddrive/features")
@Produces(value={"application/json"})
public class FeaturesService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(FeaturesService.class);
    protected final CloudDriveFeatures features;
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    private SettingService settingService;
    private static final org.exoplatform.commons.api.settings.data.Context CLOUD_DRIVE_CONTEXT = org.exoplatform.commons.api.settings.data.Context.GLOBAL.id("CLOUD_DRIVE");
    private static final Scope CLOUD_DRIVE_SCOPE = Scope.GLOBAL.id("CLOUD_DRIVE");
    private static final String IS_CLOUD_DRIVE_ENABLED = "isCloudDriveEnabled";

    public FeaturesService(CloudDriveService cloudDrives, CloudDriveFeatures features, RepositoryService jcrService, SessionProviderService sessionProviders, SettingService settingService) {
        this.cloudDrives = cloudDrives;
        this.features = features;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.settingService = settingService;
    }

    @GET
    @Path(value="/can-create-drive/")
    @RolesAllowed(value={"users"})
    public Response canCreateDrive(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path, @QueryParam(value="provider") String providerId) {
        if (workspace != null) {
            if (path != null) {
                CloudProvider provider;
                if (providerId != null && providerId.length() > 0) {
                    provider = this.cloudDrives.getProvider(providerId);
                    if (provider == null) {
                        LOG.warn((Object)("Unknown provider: " + providerId));
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unknown provider.").build();
                    }
                } else {
                    provider = null;
                }
                ConversationState currentConvo = ConversationState.getCurrent();
                try {
                    boolean result = this.features.canCreateDrive(workspace, path, currentConvo != null ? currentConvo.getIdentity().getUserId() : null, provider);
                    return Response.ok().entity((Object)("{\"result\":\"" + result + "\"}")).build();
                }
                catch (CannotCreateDriveException e) {
                    return Response.ok().entity((Object)("{\"result\":\"false\", \"message\":\"" + e.getMessage() + "\"}")).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/is-autosync-enabled/")
    @RolesAllowed(value={"users"})
    public Response isAutosyncEnabled(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        boolean result = this.features.isAutosyncEnabled(local);
                        return Response.ok().entity((Object)("{\"result\":\"" + result + "\"}")).build();
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error getting autosync status of a drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error getting autosync status of a drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/status/enabled")
    @RolesAllowed(value={"users"})
    public Response isCloudDriveEnabled(@Context UriInfo uriInfo) {
        SettingValue isCloudDriveEnabled = this.settingService.get(CLOUD_DRIVE_CONTEXT, CLOUD_DRIVE_SCOPE, IS_CLOUD_DRIVE_ENABLED);
        boolean enabled = isCloudDriveEnabled != null ? Boolean.valueOf(isCloudDriveEnabled.getValue().toString()) : true;
        return Response.ok().entity((Object)("{\"result\":\"" + enabled + "\"}")).build();
    }

    @PATCH
    @Path(value="/status/enabled")
    @RolesAllowed(value={"administrators"})
    public Response setCloudDriveStatus(@Context UriInfo uriInfo) {
        SettingValue isCloudDriveEnabled = this.settingService.get(CLOUD_DRIVE_CONTEXT, CLOUD_DRIVE_SCOPE, IS_CLOUD_DRIVE_ENABLED);
        this.settingService.set(CLOUD_DRIVE_CONTEXT, CLOUD_DRIVE_SCOPE, IS_CLOUD_DRIVE_ENABLED, SettingValue.create((Boolean)(isCloudDriveEnabled != null ? !Boolean.valueOf(isCloudDriveEnabled.getValue().toString()).booleanValue() : false)));
        return Response.ok().entity((Object)("{\"result\":\"" + ((Boolean)isCloudDriveEnabled.getValue() == false) + "\"}")).build();
    }
}

