/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.settings;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.cms.clouddrives.CloudDriveService;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.cms.clouddrives.settings.CloudDriveSettingsRestEntity;
import org.exoplatform.services.cms.clouddrives.settings.CloudDriveUserSettingsService;
import org.exoplatform.services.cms.clouddrives.settings.RestUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONObject;

@Path(value="/clouddrive/settings")
@Tag(name="/clouddrive/settings", description="Manages clouddrive connectors settings associated to users")
public class CloudDriveUserSettingsRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(CloudDriveUserSettingsRest.class);
    private CloudDriveUserSettingsService cloudDriveUserSettingsService;
    private IdentityManager identityManager;

    public CloudDriveUserSettingsRest(CloudDriveUserSettingsService cloudDriveUserSettingsService, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.cloudDriveUserSettingsService = cloudDriveUserSettingsService;
    }

    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Saves clouddrive connectors settings for authenticated user", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveUserSettings(@Parameter(description="User's clouddrive connectors settings to update", required=true) CloudDriveSettingsRestEntity cloudDriveSettingsRestEntity) {
        if (cloudDriveSettingsRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"clouddrive connectors settings object is mandatory").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            this.cloudDriveUserSettingsService.saveCloudDriveUserSettings(identityId, cloudDriveSettingsRestEntity);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving clouddrive connectors settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get clouddrive connectors settings for authenticated user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getUserSettings() {
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            String cloudDriveSettingsRestEntity = this.cloudDriveUserSettingsService.getCloudDriveUserSettings(identityId);
            return Response.ok((Object)cloudDriveSettingsRestEntity).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving clouddrive connectors settings for user with id '{}'", new Object[]{identityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/providers")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves cloud drive providers", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCloudDriveProviders() {
        try {
            CloudDriveService service = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            JSONObject providersJSON = new JSONObject();
            for (CloudProvider provider : service.getProviders()) {
                providersJSON.put(provider.getId(), (Object)new JSONObject((Object)provider));
            }
            return Response.ok((Object)providersJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while retrieving cloud drive providers", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

