/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;

public abstract class ChunkIterator<I> {
    protected Iterator<I> iter;
    protected I next;
    protected AtomicLong available = new AtomicLong();
    protected AtomicLong fetched = new AtomicLong();

    protected abstract Iterator<I> nextChunk() throws CloudDriveException;

    protected abstract boolean hasNextChunk();

    public boolean hasNext() throws CloudDriveException {
        if (this.next == null) {
            if (this.iter.hasNext()) {
                this.next = this.iter.next();
            } else {
                while (this.hasNextChunk()) {
                    this.iter = this.nextChunk();
                    if (!this.iter.hasNext()) continue;
                    this.next = this.iter.next();
                    break;
                }
            }
            return this.next != null;
        }
        return true;
    }

    public I next() throws NoSuchElementException, CloudDriveException {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException("No more data.");
        }
        I i = this.next;
        this.next = null;
        this.fetched.incrementAndGet();
        return i;
    }

    public void available(long newValue) {
        if (this.available.get() == 0L) {
            this.available.set(this.hasNextChunk() ? (long)Math.round((float)newValue * 1.25f) : newValue);
        } else {
            long newFetched = this.available.getAndAdd(this.hasNextChunk() ? (long)Math.round((float)newValue * 1.25f) : newValue);
            this.fetched.set(newFetched);
        }
    }

    public long getAvailable() {
        return this.available.get();
    }

    public long getFetched() {
        return this.fetched.get();
    }
}

