/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;

public class ActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(ActivityListener.class);
    private static final String COMMENT = "";
    private static final Boolean POST_ACTIVITY = false;
    private static final String SEPARATOR_REGEX = "\\|@\\|";
    private static final String NODE_UUID_PARAM = "id";
    private final SpaceService spaceService;
    private final SessionProviderService sessionProviderService;
    private final RepositoryService repositoryService;
    private final IShareDocumentService shareDocumentService;
    private final OrganizationService organizationService;

    public ActivityListener(SpaceService spaceService, SessionProviderService sessionProviderService, RepositoryService repositoryService, IShareDocumentService shareDocumentService, OrganizationService organizationService) {
        this.spaceService = spaceService;
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.shareDocumentService = shareDocumentService;
        this.organizationService = organizationService;
    }

    public void saveActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        this.shareActivityFilesToSpace(activityLifeCycleEvent);
    }

    private void shareActivityFilesToSpace(ActivityLifeCycleEvent activityLifeCycleEvent) {
        block10: {
            ExoSocialActivity activity = activityLifeCycleEvent.getActivity();
            List filesToShare = activity.getFiles();
            String[] uuidNodes = ((String)activity.getTemplateParams().get(NODE_UUID_PARAM)).split(SEPARATOR_REGEX);
            String streamOwner = activity.getStreamOwner();
            Space targetSpace = this.spaceService.getSpaceByPrettyName(streamOwner);
            if (targetSpace != null) {
                String[] permissions = new String[]{"read"};
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                Session session = null;
                try {
                    ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
                    String workspaceName = currentRepository.getConfiguration().getDefaultWorkspaceName();
                    session = sessionProvider.getSession(workspaceName, currentRepository);
                    if (session == null) break block10;
                    Collection memberships = null;
                    String currentUserId = ConversationState.getCurrent().getIdentity().getUserId();
                    try {
                        memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(currentUserId, targetSpace.getGroupId());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error getting memberships by user (" + currentUserId + ") and group (" + targetSpace.getGroupId() + ")"), (Throwable)e);
                    }
                    if (memberships != null) {
                        block6: for (String nodeUuid : uuidNodes) {
                            try {
                                Node node = session.getNodeByUUID(nodeUuid);
                                for (Membership membership : memberships) {
                                    String organizationalIdentity = new MembershipEntry(membership.getGroupId(), membership.getMembershipType()).toString();
                                    if (PermissionUtil.hasPermissions((Node)node, (String)organizationalIdentity, (String[])permissions)) continue;
                                    this.shareDocumentService.publishDocumentToSpace(targetSpace.getGroupId(), node, COMMENT, "read", POST_ACTIVITY);
                                    continue block6;
                                }
                            }
                            catch (RepositoryException e) {
                                LOG.error((Object)("Error while sharing document to space. Node uuid: " + nodeUuid), (Throwable)e);
                            }
                        }
                    }
                }
                catch (RepositoryException e) {
                    LOG.warn((Object)("Error while getting session for sharing files to the space: " + targetSpace.getGroupId()), (Throwable)e);
                }
            }
        }
    }

    public void updateActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void saveComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }
}

