/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.document.service.rest;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.groovyscript.text.BindingContext;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;

@Path(value="/contentviewer")
public class ContentViewerRESTService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)ContentViewerRESTService.class.getName());
    private WebAppController webAppController;
    private RepositoryService repositoryService;
    private LinkManager linkManager;

    public ContentViewerRESTService(WebAppController webAppController, RepositoryService repositoryService, LinkManager linkManager) throws Exception {
        this.webAppController = webAppController;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    @GET
    @Path(value="/{repoName}/{workspaceName}/{uuid}/")
    public Response getContent(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="uuid") String uuid) throws Exception {
        String content = null;
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            ExtendedSession session = (ExtendedSession)this.getSystemProvider().getSession(workspaceName, repository);
            Node contentNode = session.getNodeByIdentifier(uuid);
            if (contentNode != null && contentNode.isNodeType("exo:symlink")) {
                contentNode = this.linkManager.getTarget(contentNode);
            }
            StringWriter writer = new StringWriter();
            UIDocViewer uiDocViewer = new UIDocViewer();
            uiDocViewer.docPath = contentNode.getPath();
            uiDocViewer.repository = repository.getConfiguration().getName();
            uiDocViewer.workspace = workspaceName;
            uiDocViewer.setOriginalNode(contentNode);
            uiDocViewer.setNode(contentNode);
            ControllerContext controllerContext = new ControllerContext(this.webAppController, this.webAppController.getRouter(), request, response, null);
            PortalApplication application = (PortalApplication)this.webAppController.getApplication("PortalApplication");
            PortalRequestContext requestContext = new PortalRequestContext((WebuiApplication)application, controllerContext, SiteType.PORTAL.toString(), "", "", null);
            WebuiRequestContext.setCurrentInstance((RequestContext)requestContext);
            UIPortalApplication uiApplication = new UIPortalApplication();
            uiApplication.setCurrentSite(new UIPortal());
            requestContext.setUIApplication((UIApplication)uiApplication);
            requestContext.setWriter((Writer)writer);
            uiDocViewer.processRender((WebuiRequestContext)requestContext);
            content = writer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot render content of document " + repoName + "/" + workspaceName + "/" + uuid), (Throwable)e);
        }
        return Response.ok(content).build();
    }

    private SessionProvider getSystemProvider() {
        SessionProviderService service = (SessionProviderService)WCMCoreUtils.getService(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    public String getTemplate(Node contentNode) {
        if (contentNode == null) {
            return null;
        }
        org.exoplatform.services.cms.templates.TemplateService templateService = (org.exoplatform.services.cms.templates.TemplateService)CommonsUtils.getService(org.exoplatform.services.cms.templates.TemplateService.class);
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            String nodeType = contentNode.getPrimaryNodeType().getName();
            if (templateService.isManagedNodeType(nodeType)) {
                return templateService.getTemplatePathByUser(false, nodeType, userName);
            }
        }
        catch (RepositoryException re) {
            if (LOG.isDebugEnabled() || LOG.isWarnEnabled()) {
                LOG.error((Object)"Get template catch RepositoryException: ", (Throwable)re);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void processRender(String template, UIComponent uiComponent, Writer writer) throws Exception {
        if (template == null) {
            throw new IllegalStateException();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JCRResourceResolver resolver = new JCRResourceResolver("dms-system");
        BindingContext bcontext = new BindingContext((ResourceResolver)resolver, writer);
        bcontext.put((Object)"_ctx", (Object)bcontext);
        bcontext.put((Object)"uicomponent", (Object)uiComponent);
        bcontext.put((Object)uiComponent.getUIComponentName(), (Object)uiComponent);
        bcontext.put((Object)"locale", (Object)new Locale("en"));
        TemplateService service = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        service.merge(template, bcontext);
    }
}

