/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.service;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.context.DocumentContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.ext.component.document.service.IShareDocumentService;
import org.junit.Ignore;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/ecms-test-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/standalone/test-configuration.xml")})
@Ignore
public class TestService
extends AbstractKernelTest {
    protected final String REPO_NAME = "repository";
    protected final String DEFAULT_WS = "collaboration";
    protected static PortalContainer container;
    private RepositoryService repositoryService;
    protected ManageableRepository repository;
    protected SessionProvider sessionProvider;
    protected Session session;
    protected SessionProviderService sessionProviderService_;
    protected ProviderBinder providers;
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private String perm = "read,add_node,set_property";
    private String comment = "Comment";
    private String spaceName = "/spaces/space1";
    private String userName = "john";
    private String nodePath = "nodeToShare";
    private String activityId;
    private NodeLocation nodeLocation;
    private String spaceId;
    private LinkManager linkManager;

    protected void tearDown() throws Exception {
        this.session.getRootNode().getNode(this.nodePath).remove();
        this.session.save();
        ActivityManager manager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        manager.deleteActivity(this.activityId);
        SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        spaceService.deleteSpace(this.spaceId);
        RequestLifeCycle.end();
    }

    private void initContainer() {
        container = PortalContainer.getInstance();
        this.repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        this.sessionProviderService_ = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        String loginConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/login.conf").toString();
        System.setProperty("java.security.auth.login.config", loginConf);
        try {
            this.applySystemSession();
        }
        catch (Exception e) {
            TestService.fail();
            throw new RuntimeException("Failed to initialize standalone container: " + e.getMessage(), e);
        }
    }

    protected void setUp() throws Exception {
        this.begin();
        ConversationState conversionState = ConversationState.getCurrent();
        if (conversionState == null) {
            conversionState = new ConversationState(new Identity("root"));
            ConversationState.setCurrent((ConversationState)conversionState);
        }
        this.initContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        this.rootIdentity = identityManager.getOrCreateIdentity("organization", "root", false);
        this.linkManager = (LinkManager)container.getComponentInstanceOfType(LinkManager.class);
        this.nodeLocation = NodeLocation.getNodeLocationByNode((Node)this.session.getRootNode().addNode(this.nodePath));
        this.session.save();
        SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
        Space sp = this.getSpaceInstance(spaceService, "space1");
        this.spaceId = sp.getId();
        Node group = null;
        group = !this.session.getRootNode().hasNode("Groups") ? this.session.getRootNode().addNode("Groups") : this.session.getRootNode().getNode("Groups");
        Node spaces = null;
        spaces = !group.hasNode("spaces") ? group.addNode("spaces") : group.getNode("spaces");
        Node space = spaces.addNode(this.spaceName.split("/")[2]);
        space.addNode("Documents");
        this.session.save();
    }

    public void testShare() throws Exception {
        DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", false);
        IShareDocumentService temp = (IShareDocumentService)container.getComponentInstanceOfType(IShareDocumentService.class);
        this.activityId = temp.publishDocumentToSpace(this.spaceName, NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation), this.comment, this.perm);
        NodeIterator nodeIterator = this.session.getRootNode().getNode("Groups/spaces/space1/Documents/Shared").getNodes();
        TestService.assertEquals((long)1L, (long)nodeIterator.getSize());
        Node target = nodeIterator.nextNode();
        TestService.assertEquals((String)"exo:symlink", (String)target.getPrimaryNodeType().getName());
        Node origin = this.linkManager.getTarget(target, true);
        TestService.assertEquals((String)("/" + this.nodePath), (String)origin.getPath());
        ExtendedNode extendedNode = (ExtendedNode)origin;
        TestService.assertTrue((!extendedNode.getACL().getPermissions("*:" + this.spaceName).isEmpty() ? 1 : 0) != 0);
        ActivityManager manager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        ExoSocialActivity activity = manager.getActivity(this.activityId);
        TestService.assertEquals((String)this.comment, (String)activity.getTitle());
    }

    public void testShareUser() throws Exception {
        DocumentContext.getCurrent().getAttributes().put("isSkipRaiseActivity", false);
        IShareDocumentService temp = (IShareDocumentService)container.getComponentInstanceOfType(IShareDocumentService.class);
        temp.publishDocumentToUser(this.userName, NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation), this.comment, this.perm);
        NodeIterator nodeIterator = this.session.getRootNode().getNode("Users/j___/jo___/joh___/john/Private/Documents/Shared").getNodes();
        TestService.assertEquals((long)1L, (long)nodeIterator.getSize());
        Node target = nodeIterator.nextNode();
        TestService.assertEquals((String)"exo:symlink", (String)target.getPrimaryNodeType().getName());
        Node origin = this.linkManager.getTarget(target, true);
        TestService.assertEquals((String)("/" + this.nodePath), (String)origin.getPath());
        ExtendedNode extendedNode = (ExtendedNode)origin;
        TestService.assertTrue((!extendedNode.getACL().getPermissions(this.userName).isEmpty() ? 1 : 0) != 0);
    }

    public void applySystemSession() throws Exception {
        System.setProperty("gatein.tenant.repository.name", "repository");
        container = PortalContainer.getInstance();
        this.repositoryService.setCurrentRepositoryName("repository");
        this.repository = this.repositoryService.getCurrentRepository();
        this.closeOldSession();
        this.sessionProvider = this.sessionProviderService_.getSystemSessionProvider(null);
        this.session = this.sessionProvider.getSession("collaboration", this.repository);
        this.sessionProvider.setCurrentRepository(this.repository);
        this.sessionProvider.setCurrentWorkspace("collaboration");
    }

    private void closeOldSession() {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    private Space getSpaceInstance(SpaceService spaceService, String spaceName) throws Exception {
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + spaceName);
        space.setType("classic");
        space.setVisibility("open");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root"};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        spaceService.saveSpace(space, true);
        return space;
    }
}

