/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.activity.processor;

import java.util.ArrayList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.attachments.model.ActivityFileAttachment;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ActivityAttachmentProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(ActivityAttachmentProcessor.class);
    private TrashService trashService;

    public ActivityAttachmentProcessor(TrashService trashService, InitParams initParams) {
        super(initParams);
        this.trashService = trashService;
    }

    public void processActivity(ExoSocialActivity activity) {
        String[] docPaths;
        Map activityParams = activity.getTemplateParams();
        if (activityParams == null || activityParams.isEmpty() || !activityParams.containsKey("WORKSPACE") && !activityParams.containsKey("WORKSPACE".toLowerCase())) {
            return;
        }
        String[] repositories = this.getParameterValues(activityParams, "REPOSITORY");
        String[] workspaces = this.getParameterValues(activityParams, "WORKSPACE");
        String[] mimeTypes = this.getParameterValues(activityParams, "mimeType");
        String[] nodeUUIDs = this.getParameterValues(activityParams, "id");
        String[] stringArray = docPaths = activityParams.containsKey("DOCPATH") ? this.getParameterValues(activityParams, "DOCPATH") : this.getParameterValues(activityParams, "nodePath");
        if (docPaths == null) {
            return;
        }
        activity.setFiles(new ArrayList());
        for (int i = 0; i < docPaths.length; ++i) {
            String docPath = docPaths[i];
            ActivityFileAttachment fileAttachment = new ActivityFileAttachment();
            try {
                String repository = "repository";
                if (repositories != null && repositories.length == docPaths.length && StringUtils.isNotBlank((CharSequence)repositories[i])) {
                    repository = repositories[i];
                }
                String workspace = "collaboration";
                if (workspaces != null && workspaces.length == docPaths.length && StringUtils.isNotBlank((CharSequence)workspaces[i])) {
                    workspace = workspaces[i];
                }
                String mimeType = null;
                if (mimeTypes != null && mimeTypes.length == docPaths.length && StringUtils.isNotBlank((CharSequence)mimeTypes[i])) {
                    mimeType = mimeTypes[i];
                }
                String nodeUUID = null;
                if (nodeUUIDs != null && nodeUUIDs.length == docPaths.length && StringUtils.isNotBlank((CharSequence)nodeUUIDs[i])) {
                    nodeUUID = nodeUUIDs[i];
                }
                fileAttachment.setRepository(repository);
                fileAttachment.setWorkspace(workspace);
                fileAttachment.setId(nodeUUID);
                fileAttachment.setDocPath(docPath);
                fileAttachment.setMimeType(mimeType);
                activity.getFiles().add(fileAttachment);
                NodeLocation nodeLocation = new NodeLocation(repository, workspace, docPath, nodeUUID, true);
                Node contentNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
                if (contentNode == null || !contentNode.isNodeType("mix:referenceable")) {
                    fileAttachment.setDeleted(true);
                    continue;
                }
                if (nodeUUID == null) {
                    fileAttachment.setId(contentNode.getUUID());
                }
                fileAttachment.setName(this.getTitle(contentNode));
                fileAttachment.setDeleted(this.trashService.isInTrash(contentNode) || this.isQuarantinedItem(contentNode));
                continue;
            }
            catch (Exception e) {
                fileAttachment.setDeleted(true);
                LOG.warn("Error while geting attached file: {}. Continue retrieving the other attachments anyway.", new Object[]{docPath, e});
            }
        }
    }

    private String getTitle(Node contentNode) throws RepositoryException {
        String nodeTitle;
        try {
            nodeTitle = Utils.getTitle((Node)contentNode);
        }
        catch (Exception e) {
            nodeTitle = contentNode.getName();
        }
        return nodeTitle;
    }

    private boolean isQuarantinedItem(Node node) throws RepositoryException {
        return node.getPath().startsWith("/Quarantine/");
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value == null) {
            value = activityParams.get(paramName.toLowerCase());
        }
        if (value != null) {
            values = value.split("\\|@\\|");
        }
        return values;
    }
}

