/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.ckeditor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.io.IOUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecms.uploads.HTMLUploadImageProcessorImpl;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class HTMLUploadImageProcessorTest {
    @Rule
    public TemporaryFolder uploadFolder = new TemporaryFolder();
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private UploadService uploadService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private Session session;
    @Mock
    private SessionProvider sessionProvider;
    @Mock
    private LinkManager linkManager;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    private WCMService wcmService;

    @Test
    public void shouldReturnSameContentWhenNoEmbeddedImage() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with no images</p>";
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProvider.getSession(null, this.repository)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID(Mockito.anyString())).thenReturn((Object)node);
        String processedContent = imageProcessor.processImages(content, "nodeParent", null);
        Assert.assertEquals((Object)content, (Object)processedContent);
    }

    @Test
    public void shouldReturnUpdatedContentWhenEmbeddedImage() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with image: <img src=\"/portal/image?uploadId=123456\" /></p>";
        Node node = (Node)Mockito.mock(Node.class);
        File imageFile = this.uploadFolder.newFile("image.png");
        UploadResource uploadImage = new UploadResource("123456", "image.png");
        uploadImage.setStoreLocation(imageFile.getPath());
        Mockito.when((Object)this.uploadService.getUploadResource((String)Mockito.eq((Object)"123456"))).thenReturn((Object)uploadImage);
        Mockito.when((Object)node.hasNode((String)Mockito.eq((Object)"image.png"))).thenReturn((Object)false);
        Mockito.when((Object)node.addNode(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryEntry.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.sessionProvider.getSession(null, this.repository)).thenReturn((Object)this.session);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)this.session.getNodeByUUID(Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)"/path/to/image.png");
        String processedContent = imageProcessor.processImages(content, "nodeParent", null);
        Assert.assertTrue((boolean)processedContent.matches("<p>content with image: <img src=\"/portal/rest/images/repository/collaboration/[a-z0-9]+\" /></p>"));
    }

    @Test
    public void shouldReturnUpdatedContentWhenEmbeddedImageForSpace() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with image: <img src=\"/portal/image?uploadId=123456\" /></p>";
        Node node = (Node)Mockito.mock(Node.class);
        File imageFile = this.uploadFolder.newFile("image.png");
        UploadResource uploadImage = new UploadResource("123456", "image.png");
        uploadImage.setStoreLocation(imageFile.getPath());
        Mockito.when((Object)this.uploadService.getUploadResource((String)Mockito.eq((Object)"123456"))).thenReturn((Object)uploadImage);
        Mockito.when((Object)node.hasNode((String)Mockito.eq((Object)"image.png"))).thenReturn((Object)false);
        Mockito.when((Object)node.addNode(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryEntry.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.sessionProvider.getSession("collaboration", this.repository)).thenReturn((Object)this.session);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)this.session.getRootNode()).thenReturn((Object)node);
        Mockito.when((Object)node.getNode(Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)"/path/to/image.png");
        String processedContent = imageProcessor.processSpaceImages(content, "nodeParent", null);
        Assert.assertTrue((boolean)processedContent.matches("<p>content with image: <img src=\"/portal/rest/images/repository/collaboration/[a-z0-9]+\" /></p>"));
    }

    @Test
    public void shouldReturnUpdatedContentWhenEmbeddedImportedImageForSpace() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with image: <img src=\"//-image.png-//\" /></p>";
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.hasNode((String)Mockito.eq((Object)"image.png"))).thenReturn((Object)false);
        Mockito.when((Object)node.addNode(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryEntry.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.sessionProvider.getSession("collaboration", this.repository)).thenReturn((Object)this.session);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"123524");
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)this.session.getRootNode()).thenReturn((Object)node);
        Mockito.when((Object)node.getNode(Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)"/path/to/image.png");
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "image.png");
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)new ByteArrayInputStream("test data".getBytes()), (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the file", e);
        }
        String processedContent = imageProcessor.processSpaceImages(content, "nodeParent", null);
        Assert.assertTrue((boolean)processedContent.matches("<p>content with image: <img src=\"/portal/rest/images/repository/collaboration/[a-z0-9]+\" /></p>"));
    }

    @Test
    public void shouldReturnUpdatedContentWhenEmbeddedImageForUser() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with image: <img src=\"/portal/image?uploadId=123456\" /></p>";
        Node node = (Node)Mockito.mock(Node.class);
        File imageFile = this.uploadFolder.newFile("image.png");
        UploadResource uploadImage = new UploadResource("123456", "image.png");
        uploadImage.setStoreLocation(imageFile.getPath());
        Mockito.when((Object)this.uploadService.getUploadResource((String)Mockito.eq((Object)"123456"))).thenReturn((Object)uploadImage);
        Mockito.when((Object)node.hasNode((String)Mockito.eq((Object)"image.png"))).thenReturn((Object)false);
        Mockito.when((Object)node.addNode(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(null)).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryEntry.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.nodeHierarchyCreator.getUserNode(this.sessionProvider, "userId")).thenReturn((Object)node);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)"/path/to/image.png");
        String processedContent = imageProcessor.processUserImages(content, "userId", null);
        Assert.assertTrue((boolean)processedContent.matches("<p>content with image: <img src=\"/portal/rest/images/repository/collaboration/[a-z0-9]+\" /></p>"));
    }

    @Test
    public void shouldReturnUpdatedContentForExport() throws Exception {
        HTMLUploadImageProcessorImpl imageProcessor = new HTMLUploadImageProcessorImpl(this.portalContainer, this.uploadService, this.repositoryService, this.linkManager, this.sessionProviderService, this.nodeHierarchyCreator, this.wcmService);
        String content = "<p>content with image: <img src=\"/portal/rest/images/repository/collaboration/123456\" /></p>";
        Node node = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.portalContainer.getName()).thenReturn((Object)"portal");
        Mockito.when((Object)this.portalContainer.getRestContextName()).thenReturn((Object)"rest");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getName()).thenReturn((Object)"repository");
        Mockito.when((Object)this.wcmService.getReferencedContent((SessionProvider)Mockito.anyObject(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)node.getNode(Mockito.anyString())).thenReturn((Object)node);
        Mockito.when((Object)node.getName()).thenReturn((Object)"image.png");
        Mockito.when((Object)node.getProperty(Mockito.anyString())).thenReturn((Object)property);
        Mockito.when((Object)property.getStream()).thenReturn((Object)new ByteArrayInputStream("test data".getBytes()));
        String processedContent = imageProcessor.processImagesForExport(content);
        Assert.assertTrue((boolean)processedContent.matches("<p>content with image: <img src=\"//-image.png-//\" /></p>"));
    }
}

