/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.addons.rdbms.listener;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class WCMActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(WCMActivityUpdaterListener.class);
    public static final String LINK_ACTIVITY_TYPE = "LINK_ACTIVITY";

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        String type;
        ExoSocialActivity oldActivity = (ExoSocialActivity)event.getSource();
        switch (type = oldActivity.getType() == null ? "" : oldActivity.getType()) {
            case "LINK_ACTIVITY": {
                this.migrationLinkActivity(oldActivity, (String)event.getData());
                break;
            }
            case "contents:spaces": {
                this.migrationContentSpaceActivity(oldActivity, (String)event.getData());
                break;
            }
            case "files:spaces": {
                this.migrationFileSpaceActivity(oldActivity, (String)event.getData());
                break;
            }
        }
    }

    private void migrationLinkActivity(ExoSocialActivity oldActivity, String newId) {
    }

    private void migrationContentSpaceActivity(ExoSocialActivity oldActivity, String newId) {
    }

    private void migrationFileSpaceActivity(ExoSocialActivity activity, String newId) throws RepositoryException {
        if (activity.isComment()) {
            LOG.info((Object)String.format("Migration file-spaces comment '%s' with new id's %s", activity.getTitle(), newId));
            this.migrationDoc(activity, newId);
        } else {
            LOG.info((Object)String.format("Migration file-spaces activity '%s' with new id's %s", activity.getTitle(), newId));
            this.migrationDoc(activity, newId);
        }
    }

    private void migrationDoc(ExoSocialActivity activity, String newId) throws RepositoryException {
        String workspace = (String)activity.getTemplateParams().get("WORKSPACE");
        if (workspace == null) {
            workspace = (String)activity.getTemplateParams().get("WORKSPACE".toLowerCase());
        }
        String docId = (String)activity.getTemplateParams().get("id");
        Node docNode = this.getDocNode(workspace, activity.getUrl(), docId);
        if (docNode != null && docNode.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            LOG.info((Object)("Migration doc: " + docNode.getPath()));
            try {
                ActivityTypeUtils.attachActivityId((Node)docNode, (String)newId);
                docNode.getSession().save();
            }
            catch (RepositoryException e) {
                LOG.warn((Object)"Updates the file-spaces activity is unsuccessful!");
                LOG.debug((Object)"Updates the file-spaces activity is unsuccessful!", (Throwable)e);
            }
        } else {
            LOG.info((Object)String.format("Missing document's path/Id on template-parameters. Do not migrate this file-spaces activity width old id %s - new id %s", activity.getId(), newId));
        }
    }

    private Node getDocNode(String workspace, String path, String nodeId) {
        if (workspace == null || nodeId == null && path == null) {
            return null;
        }
        try {
            Session session = SessionProviderService.getSystemSessionProvider().getSession(workspace, SessionProviderService.getRepository());
            try {
                return session.getNodeByUUID(nodeId);
            }
            catch (Exception e) {
                return (Node)session.getItem(path);
            }
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

