/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class QueryUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private QueryService queryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repositoryService_;

    public QueryUpgradePlugin(QueryService queryService, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, DMSConfiguration dmsConfiguration, InitParams initParams) {
        super(initParams);
        this.queryService_ = queryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedQueries = PrivilegedSystemHelper.getProperty((String)"unchanged-queries");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedQueries)) {
            unchangedQueries = "";
        }
        try {
            HashSet<String> unchangedQuerySet = new HashSet<String>();
            Set allConfiguredQueries = this.queryService_.getAllConfiguredQueries();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedQuery : unchangedQueries.split(",")) {
                unchangedQuerySet.add(unchangedQuery.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
            Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), this.repositoryService_.getCurrentRepository());
            String queriesNodePath = this.nodeHierarchyCreator_.getJcrPath("queriesPath");
            Node queriesNode = (Node)session.getItem(queriesNodePath);
            NodeIterator nodeIter = queriesNode.getNodes();
            while (nodeIter.hasNext()) {
                Node queryNode = nodeIter.nextNode();
                if (!queryNode.isNodeType("nt:query") || unchangedQuerySet.contains(queryNode.getName()) || !allConfiguredQueries.contains(queryNode.getName())) continue;
                removedNodes.add(queryNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    queriesNode.save();
                }
                catch (Exception e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.error((Object)("Error in " + this.getName() + ": Can not remove old query node: " + removedNode.getPath()));
                }
            }
            this.queryService_.init();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating scripts", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

