/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SiteExplorerTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repositoryService_;
    private ManageViewService manageViewService_;

    public SiteExplorerTemplateUpgradePlugin(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageViewService manageViewService, InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
        this.manageViewService_ = manageViewService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedViews = PrivilegedSystemHelper.getProperty((String)"unchanged-site-explorer-templates");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedViews)) {
            unchangedViews = "";
        }
        try {
            HashSet<String> unchangedViewSet = new HashSet<String>();
            Set configuredTemplates = this.manageViewService_.getConfiguredTemplates();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedView : unchangedViews.split(",")) {
                unchangedViewSet.add(unchangedView.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
            Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), this.repositoryService_.getCurrentRepository());
            String ecmExplorerViewNodePath = this.nodeHierarchyCreator_.getJcrPath("ecmExplorerTemplates");
            Node ecmExplorerViewNode = (Node)session.getItem(ecmExplorerViewNodePath);
            NodeIterator iter = ecmExplorerViewNode.getNodes();
            while (iter.hasNext()) {
                Node viewNode = iter.nextNode();
                if (unchangedViewSet.contains(viewNode.getName()) || !configuredTemplates.contains(viewNode.getName())) continue;
                removedNodes.add(viewNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    ecmExplorerViewNode.save();
                }
                catch (Exception e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.error((Object)("Error in " + this.getName() + ": Can not remove old query node: " + removedNode.getPath()));
                }
            }
            this.manageViewService_.init();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating Site Explorer views:", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

