/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.path;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodePathUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private RepositoryService repositoryService_;
    private String srcNode;
    private String destNode;

    public NodePathUpgradePlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repositoryService_ = repoService;
        this.srcNode = initParams.getValueParam("source.node").getValue();
        this.destNode = initParams.getValueParam("target.node").getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        if (this.srcNode == null || "".equals(this.srcNode) || this.destNode == null || "".equals(this.destNode)) {
            this.log.info((Object)"Source and target node must be set to run plugin!");
            return;
        }
        String workspace = this.srcNode.split(":")[0];
        String nodePath = this.srcNode.split(":")[1];
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ExtendedSession session = (ExtendedSession)sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            Node sourceNode = session.getRootNode().getNode(nodePath.substring(1));
            Node targetNode = null;
            try {
                targetNode = session.getRootNode().getNode(this.destNode.substring(1));
            }
            catch (PathNotFoundException pne) {
                targetNode = session.getRootNode().addNode("sites");
                session.getRootNode().save();
            }
            if (sourceNode.hasNodes()) {
                NodeIterator iter = sourceNode.getNodes();
                while (iter.hasNext()) {
                    Node child = (Node)iter.next();
                    if (targetNode.hasNode(child.getName())) {
                        targetNode.getNode(child.getName()).remove();
                        session.save();
                    }
                    this.log.info((Object)("Move " + nodePath + "/" + child.getName() + " to " + this.destNode + "/" + child.getName()));
                    session.move(nodePath + "/" + child.getName(), this.destNode + "/" + child.getName(), false);
                    session.save();
                }
                sourceNode.remove();
                session.save();
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected error happens in moving nodes", new Object[]{e.getMessage()});
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

