/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.nodetypes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ActionTypeUpgradePlugin
extends UpgradeProductPlugin {
    private static final String[] actionTypes = new String[]{"exo:addMetadataAction", "exo:trashFolderAction", "exo:addToFavoriteAction", "exo:taxonomyAction", "exo:enableVersioning", "exo:autoVersioning", "exo:populateToMenu"};
    private static final String[] properties = new String[]{"exo:script", "exo:scriptLabel"};
    private Log log = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public ActionTypeUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        HashSet<String> propertySet = new HashSet<String>(Arrays.asList(properties));
        ExtendedNodeTypeManager nodeTypeManager = WCMCoreUtils.getRepository().getNodeTypeManager();
        for (String actionType : actionTypes) {
            try {
                NodeTypeValue nodeTypeValue = nodeTypeManager.getNodeTypeValue(actionType);
                List propValues = nodeTypeValue.getDeclaredPropertyDefinitionValues();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Migrating " + actionType + "............."));
                }
                for (PropertyDefinitionValue propValue : propValues) {
                    if (!propertySet.contains(propValue.getName())) continue;
                    propValue.setReadOnly(false);
                }
                nodeTypeValue.setDeclaredPropertyDefinitionValues(propValues);
                nodeTypeManager.registerNodeType(nodeTypeValue, 4);
            }
            catch (NoSuchNodeTypeException e) {
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("An unexpected error occurs when migrating action node type: " + actionType), (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

