/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.script;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.scripts.impl.ScriptServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ScriptUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)ScriptUpgradePlugin.class.getName());
    private ScriptService scriptService_;

    public ScriptUpgradePlugin(ScriptService scriptService, InitParams initParams) {
        super(initParams);
        this.scriptService_ = scriptService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-scripts");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedTemplates)) {
            unchangedTemplates = "";
        }
        try {
            HashSet<String> unchangedTemplateSet = new HashSet<String>();
            Set allConfiguredScripts = this.scriptService_.getAllConfiguredScripts();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedTemplate : unchangedTemplates.split(",")) {
                unchangedTemplateSet.add(unchangedTemplate.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node ecmExplorer = this.scriptService_.getECMScriptHome(sessionProvider);
            QueryManager queryManager = ecmExplorer.getSession().getWorkspace().getQueryManager();
            NodeIterator iter = queryManager.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + ecmExplorer.getPath() + "/%'", "sql").execute().getNodes();
            while (iter.hasNext()) {
                Node scriptNode = iter.nextNode();
                if (unchangedTemplateSet.contains(scriptNode.getPath().substring(ecmExplorer.getPath().length() + 1)) || !allConfiguredScripts.contains(scriptNode.getName())) continue;
                removedNodes.add(scriptNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    ecmExplorer.save();
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) continue;
                    log.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
            ((ScriptServiceImpl)this.scriptService_).start();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"An unexpected error occurs when migrating scripts", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

