/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.sites;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;

public class SiteDataUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)SiteDataUpgradePlugin.class.getName());
    private static final String[] childNodePaths = new String[]{"js", "css", "medias", "medias/images", "medias/videos", "medias/audio", "documents", "web contents", "web contents/site artifacts", "links", "categories", "ApplicationData", "ApplicationData/NewsletterApplication", "ApplicationData/DefaultTemplates", "ApplicationData/Categories", "ApplicationData/Users"};
    private WCMConfigurationService wcmConfigService;

    public SiteDataUpgradePlugin(WCMConfigurationService wcmConfigService, InitParams initParams) {
        super(initParams);
        this.wcmConfigService = wcmConfigService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block13: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            try {
                for (NodeLocation rootSiteLocation : this.wcmConfigService.getAllLivePortalsLocation()) {
                    try {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Migrating data for site: " + rootSiteLocation.getPath()));
                        }
                        rootSiteLocation.setSystemSession(true);
                        Node rootSiteNode = NodeLocation.getNodeByLocation((NodeLocation)rootSiteLocation);
                        NodeIterator iter = rootSiteNode.getNodes();
                        while (iter.hasNext()) {
                            Node siteNode = iter.nextNode();
                            for (String childPath : childNodePaths) {
                                try {
                                    if (!siteNode.hasNode(childPath)) continue;
                                    Node node = siteNode.getNode(childPath);
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Migrating data for site: " + node.getPath()));
                                    }
                                    this.addMixin(node, "exo:modify");
                                    this.addMixin(node, "exo:sortable");
                                    if (node.hasProperty("exo:name")) continue;
                                    node.setProperty("exo:name", node.getName());
                                    node.setProperty("exo:lastModifiedDate", (Calendar)new GregorianCalendar());
                                    ConversationState conversationState = ConversationState.getCurrent();
                                    String userName = conversationState == null ? node.getSession().getUserID() : conversationState.getIdentity().getUserId();
                                    node.setProperty("exo:lastModifier", userName);
                                }
                                catch (Exception e) {
                                    if (!log.isErrorEnabled()) continue;
                                    log.error((Object)"An unexpected error occurs when migrating site data", (Throwable)e);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("An unexpected error occurs when migrating site " + rootSiteLocation.getPath()), (Throwable)e);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully"));
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block13;
                log.error((Object)"An unexpected error occurs when migrating site data", (Throwable)e);
            }
        }
    }

    protected void addMixin(Node node, String mixin) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!node.isNodeType(mixin)) {
            node.addMixin(mixin);
        }
    }
}

