/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import org.exoplatform.ecm.webui.component.admin.repository.UIPermissionContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspacePermissionForm;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UIWorkspacePermissionForm
extends UIForm
implements UISelectable {
    public static final String FIELD_PERMISSION = "permission";

    public UIWorkspacePermissionForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).addValidator(MandatoryValidator.class, new Object[0]).setEditable(false));
        for (String perm : PermissionType.ALL) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(perm, perm, null));
        }
    }

    protected boolean isCheckedAny() {
        for (String perm : PermissionType.ALL) {
            if (!this.getUIFormCheckBoxInput(perm).isChecked()) continue;
            return true;
        }
        return false;
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)value.toString());
        this.checkAll(false);
    }

    public void reset() {
        this.getUIStringInput(FIELD_PERMISSION).setValue(null);
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        for (String perm : PermissionType.ALL) {
            this.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected void lockForm(boolean lock) {
        boolean editable = !lock;
        UIPermissionContainer uiContainer = (UIPermissionContainer)this.getAncestorOfType(UIPermissionContainer.class);
        ((UIPermissionSelector)uiContainer.getChild(UIPermissionSelector.class)).setRendered(editable);
        this.getUIStringInput(FIELD_PERMISSION).setEditable(false);
        for (String perm : PermissionType.ALL) {
            this.getUIFormCheckBoxInput(perm).setEnable(editable);
        }
        if (!editable) {
            this.setActions(new String[]{"Cancel"});
        } else {
            this.setActions(new String[]{"Save", "Cancel"});
        }
    }
}

