/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.picocontainer.PicoIntrospectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(listeners={AddWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ShowHiddenActionListener.class}), @EventConfig(listeners={RemoveWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditWorkspaceActionListener.class})})
public class UIRepositoryForm
extends UIForm
implements UIPopupComponent {
    private ConfigurationManager configurationManager;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIRepositoryForm");
    public static final String ST_ADD = "AddRepoPopup";
    public static final String ST_EDIT = "EditRepoPopup";
    public static final String POPUP_WORKSPACE = "PopupWorkspace";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WSINPUTSET = "wsInputSet";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_ISDEFAULT = "isDefault";
    public static final String FIELD_ACCESSCONTROL = "accessControl";
    public static final String FIELD_AUTHINPUTSET = "authInputSet";
    public static final String FIELD_AUTHENTICATION = "authenticationPolicy";
    public static final String FIELD_SCURITY = "securityDomain";
    public static final String FIELD_SESSIONTIME = "sessionTime";
    public static final String FIELD_REPCHANNEL = "channelConfig";
    public static final String FIELD_REPENABLE = "enableReplication";
    public static final String FIELD_REPMODE = "repMode";
    public static final String FIELD_REPTESTMODE = "repTestMode";
    public static final String FIELD_BSEPATH = "directoryPath";
    public static final String FIELD_BSEMAXBUFFER = "maxBufferSize";
    public static final String KEY_AUTHENTICATIONPOLICY = "org.exoplatform.services.jcr.impl.core.access.JAASAuthenticator";
    protected boolean isAddnew_ = true;
    protected String defaulWorkspace_ = null;
    protected String dmsSystemWorkspace_ = null;
    protected String repoName_ = null;
    protected Map<String, WorkspaceEntry> workspaceMap_ = new HashMap();
    protected Map<String, String> workspaceMapNodeType_ = new HashMap();
    protected Map<String, String> workspaceMapPermission_ = new HashMap();
    protected Map<String, String> defaulWorkspaceMap = new HashMap();

    public UIRepositoryForm() throws Exception {
        this.configurationManager = (ConfigurationManager)this.getApplicationComponent(ConfigurationManager.class);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction workspaceField = new UIFormInputSetWithAction(FIELD_WSINPUTSET);
        workspaceField.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_WORKSPACE, FIELD_WORKSPACE, null));
        workspaceField.setActionInfo(FIELD_WORKSPACE, new String[]{"EditWorkspace", "RemoveWorkspace"});
        this.addUIComponentInput((UIComponent)workspaceField);
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_ISDEFAULT, FIELD_ISDEFAULT, null).setEditable(false));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_ACCESSCONTROL, FIELD_ACCESSCONTROL, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction autField = new UIFormInputSetWithAction(FIELD_AUTHINPUTSET);
        autField.addChild((UIComponent)new UIFormStringInput(FIELD_AUTHENTICATION, FIELD_AUTHENTICATION, null).addValidator(MandatoryValidator.class, new Object[0]));
        autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        this.addChild((UIComponent)autField);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SCURITY, FIELD_SCURITY, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SESSIONTIME, FIELD_SESSIONTIME, null));
    }

    public void refresh(RepositoryEntry repo) throws Exception {
        this.reset();
        this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        this.workspaceMap_.clear();
        if (repo != null) {
            if (this.isAddnew_) {
                this.repoName_ = null;
                this.defaulWorkspace_ = null;
                this.dmsSystemWorkspace_ = null;
                this.refreshWorkspaceList();
                this.getUIStringInput(FIELD_NAME).setEditable(true);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                this.setActions(new String[]{"Save", "AddWorkspace", "Reset", "Close"});
            } else {
                this.repoName_ = repo.getName();
                this.defaulWorkspace_ = repo.getDefaultWorkspaceName();
                this.dmsSystemWorkspace_ = repo.getSystemWorkspaceName();
                for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                    this.workspaceMap_.put(ws.getName(), ws);
                }
                this.getUIStringInput(FIELD_NAME).setEditable(false);
                this.getUIStringInput(FIELD_NAME).setValue((Object)repo.getName());
                this.refreshWorkspaceList();
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(this.isDefaultRepo(repo.getName()));
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                autField.setActionInfo(FIELD_AUTHENTICATION, null);
                this.setActions(new String[]{"AddWorkspace", "Close"});
            }
            this.getUIStringInput(FIELD_ACCESSCONTROL).setValue((Object)repo.getAccessControl());
            autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)repo.getAuthenticationPolicy());
            this.getUIStringInput(FIELD_SCURITY).setValue((Object)repo.getSecurityDomain());
            this.getUIStringInput(FIELD_SESSIONTIME).setValue((Object)String.valueOf(repo.getSessionTimeOut()));
        }
    }

    protected void lockForm(boolean isLock) throws Exception {
        boolean editable = !isLock;
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        if (isLock) {
            autField.setActionInfo(FIELD_AUTHENTICATION, null);
        } else {
            autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        }
        this.getUIStringInput(FIELD_ACCESSCONTROL).setEditable(editable);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setEditable(editable);
        this.getUIStringInput(FIELD_SCURITY).setEditable(editable);
        this.getUIStringInput(FIELD_SESSIONTIME).setEditable(editable);
    }

    protected boolean isDefaultWorkspace(String workspaceName) {
        return workspaceName.equals(this.defaulWorkspace_);
    }

    protected boolean isDmsSystemWorkspace(String workspaceName) {
        return workspaceName.equals(this.dmsSystemWorkspace_);
    }

    protected boolean isExistWorkspace(String workspaceName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        for (RepositoryEntry repo : rservice.getConfig().getRepositoryConfigurations()) {
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                if (!ws.getName().equals(workspaceName)) continue;
                return true;
            }
        }
        return false;
    }

    protected WorkspaceEntry getWorkspace(String workspaceName) {
        return (WorkspaceEntry)this.workspaceMap_.get(workspaceName);
    }

    protected Map<String, WorkspaceEntry> getWorkspaceMap() {
        return this.workspaceMap_;
    }

    protected String getWorkspaceMapNodeType(String workspaceName) {
        return (String)this.workspaceMapNodeType_.get(workspaceName);
    }

    protected Map<String, String> getWorkspaceMapNodeType() {
        return this.workspaceMapNodeType_;
    }

    protected String getWorkspaceMapPermission(String workspaceName) {
        return (String)this.workspaceMapPermission_.get(workspaceName);
    }

    protected Map<String, String> getWorkspaceMapPermission() {
        return this.workspaceMapPermission_;
    }

    protected void refreshWorkspaceList() {
        StringBuilder labels = new StringBuilder();
        for (String wsName : this.workspaceMap_.keySet()) {
            if (labels.length() > 0) {
                labels.append(",");
            }
            labels.append(wsName);
        }
        UIFormInputSetWithAction workspaceField = (UIFormInputSetWithAction)this.getChildById(FIELD_WSINPUTSET);
        workspaceField.setInfoField(FIELD_WORKSPACE, labels.toString());
    }

    protected boolean isDefaultRepo(String repoName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rservice.getConfig().getDefaultRepositoryName().equals(repoName);
    }

    protected void saveRepo(RepositoryEntry repositoryEntry) throws Exception {
        InitialContextInitializer ic = (InitialContextInitializer)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(InitialContextInitializer.class);
        RegistryService registryService = (RegistryService)this.getApplicationComponent(RegistryService.class);
        if (ic != null) {
            ic.recall();
        }
        RepositoryService rService = (RepositoryService)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(RepositoryService.class);
        if (this.isAddnew_) {
            try {
                rService.createRepository(repositoryEntry);
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (!ws.getName().equals(repositoryEntry.getSystemWorkspaceName())) continue;
                    registryService.addRegistryLocation(repositoryEntry.getName(), ws.getName());
                }
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (rService.getRepository(repositoryEntry.getName()).isWorkspaceInitialized(ws.getName())) continue;
                    rService.getRepository(repositoryEntry.getName()).configWorkspace(ws);
                    rService.getRepository(repositoryEntry.getName()).createWorkspace(ws.getName());
                }
            }
            catch (RepositoryConfigurationException repositoryConfigurationException) {
                return;
            }
            catch (PicoIntrospectionException picoIntrospectionException) {
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                return;
            }
            this.initServices(repositoryEntry.getName());
            if (rService.getConfig().isRetainable()) {
                rService.getConfig().retain();
            }
        }
    }

    private void initServices(String repository) throws Exception {
        try {
            RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            InputStream xml = this.configurationManager.getURL("classpath:/conf/portal/registry-nodetypes.xml").openStream();
            rService.getRepository(repository).getNodeTypeManager().registerNodeTypes(xml, 0);
            xml.close();
            ((RegistryService)this.getApplicationComponent(RegistryService.class)).initStorage(false);
            ((NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class)).init(repository);
            ((TaxonomyService)this.getApplicationComponent(TaxonomyService.class)).init(repository);
            ((ManageDriveService)this.getApplicationComponent(ManageDriveService.class)).init(repository);
            ((NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class)).init(repository);
            ((MetadataService)this.getApplicationComponent(MetadataService.class)).init(repository);
            ((QueryService)this.getApplicationComponent(QueryService.class)).init(repository);
            ((RelationsService)this.getApplicationComponent(RelationsService.class)).init(repository);
            ((ScriptService)this.getApplicationComponent(ScriptService.class)).initRepo(repository);
            ((TemplateService)this.getApplicationComponent(TemplateService.class)).init(repository);
            ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).init(repository);
            ((ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class)).init(repository);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (ItemExistsException itemExistsException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return;
        }
    }

    protected void ShowHidden() {
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.repoName_ = null;
    }

    private void addConfiguration(String fileConfiguration) throws Exception {
        block4: {
            SAXBuilder builder1 = new SAXBuilder();
            Document docConfiguration = null;
            Element rootConfiguration = null;
            boolean isExist = false;
            try {
                docConfiguration = builder1.build(fileConfiguration);
                rootConfiguration = docConfiguration.getRootElement();
                List listImportElement = rootConfiguration.getChildren("import");
                for (int i = 0; i < listImportElement.size(); ++i) {
                    Element element = (Element)listImportElement.get(i);
                    if (!element.getValue().trim().equals("dms-common-extend-configuration.xml")) continue;
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    Element importElement = new Element("import");
                    importElement.addContent("dms-common-extend-configuration.xml");
                    rootConfiguration.addContent((Content)importElement);
                    XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
                    xmlOutputter.output(docConfiguration, (Writer)new FileWriter(fileConfiguration));
                }
            }
            catch (FileNotFoundException e) {
                StringBuilder builder = new StringBuilder();
                PrintWriter outputStream = null;
                builder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                builder.append("<configuration>\n");
                builder.append("  <import>dms-common-extend-configuration.xml</import>\n");
                builder.append("</configuration>\n");
                FileWriter outputFileReader = new FileWriter(fileConfiguration);
                outputStream = new PrintWriter(outputFileReader);
                outputStream.println(builder);
                if (outputStream == null) break block4;
                outputStream.close();
            }
        }
    }

    private void addElement(String fileDmsCommon, String repoName, String systemWs) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        Element root = null;
        int count = 0;
        PrintWriter outputStream = null;
        try {
            doc = builder.build(fileDmsCommon);
        }
        catch (FileNotFoundException e) {
            StringBuilder builderString = new StringBuilder();
            builderString.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            builderString.append("<configuration>\n");
            builderString.append("  <component>\n");
            builderString.append("    <key>org.exoplatform.services.cms.impl.DMSConfiguration</key>\n");
            builderString.append("    <type>org.exoplatform.services.cms.impl.DMSConfiguration</type>\n");
            builderString.append("  </component>\n");
            builderString.append("</configuration>\n");
            FileWriter outputFileReader = new FileWriter(fileDmsCommon);
            outputStream = new PrintWriter(outputFileReader);
            outputStream.println(builderString);
            outputStream.close();
            doc = builder.build(fileDmsCommon);
        }
        root = doc.getRootElement();
        count = root.getChildren("external-component-plugins").size();
        Element externalElement = new Element("external-component-plugins");
        Element targetComponent = new Element("target-component");
        targetComponent.addContent("org.exoplatform.services.cms.impl.DMSConfiguration");
        Element componentPlugin = new Element("component-plugin");
        Element name = new Element(FIELD_NAME);
        name.addContent("dmsconfiguration.plugin" + count);
        Element setMethod = new Element("set-method");
        setMethod.addContent("addPlugin");
        Element type = new Element("type");
        type.addContent("org.exoplatform.services.cms.impl.DMSRepositoryConfiguration");
        Element initParams = new Element("init-params");
        Element valueParam1 = new Element("value-param");
        Element nameRepoParam = new Element(FIELD_NAME);
        nameRepoParam.addContent("repository");
        Element valueRepoParam = new Element("value");
        valueRepoParam.addContent(repoName);
        valueParam1.addContent((Content)nameRepoParam);
        valueParam1.addContent((Content)valueRepoParam);
        Element valueParam2 = new Element("value-param");
        Element nameWsParam = new Element(FIELD_NAME);
        nameWsParam.addContent("systemWorkspace");
        Element valueWsParam = new Element("value");
        valueWsParam.addContent(systemWs);
        valueParam2.addContent((Content)nameWsParam);
        valueParam2.addContent((Content)valueWsParam);
        initParams.addContent((Content)valueParam1);
        initParams.addContent((Content)valueParam2);
        componentPlugin.addContent((Content)name);
        componentPlugin.addContent((Content)setMethod);
        componentPlugin.addContent((Content)type);
        componentPlugin.addContent((Content)initParams);
        externalElement.addContent((Content)targetComponent);
        externalElement.addContent((Content)componentPlugin);
        root.addContent((Content)externalElement);
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(doc, (Writer)new FileWriter(fileDmsCommon));
    }

    private void addNewElement(String repoName, String wsName) throws Exception {
        J2EEServerInfo jServerInfo = new J2EEServerInfo();
        String configDir = jServerInfo.getExoConfigurationDirectory();
        String commonExtPath = configDir + "/dms-common-extend-configuration.xml";
        File configDirFile = new File(configDir);
        if (!configDirFile.exists()) {
            configDirFile.mkdir();
            File gadgets = new File(configDir + "/gadgets");
            gadgets.mkdir();
            new FileWriter(configDir + "/gadgets/key.txt");
        }
        this.addConfiguration(configDir + "/configuration.xml");
        this.addElement(commonExtPath, repoName, wsName);
    }

    public void setAuthentication(String value) {
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)value);
    }

    static /* synthetic */ void access$000(UIRepositoryForm x0, String x1, String x2) throws Exception {
        x0.addNewElement(x1, x2);
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

