/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.Iterator;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIRepositoryList.msg.confirm-delete"), @EventConfig(listeners={CloseActionListener.class})})
public class UIRepositoryList
extends UIGrid
implements UIPopupComponent {
    private static String[] REPO_BEAN_FIELD = new String[]{"name", "workspaces", "isdefault", "accesscontrol", "sessiontimeout"};
    private static String[] REPO_ACTION = new String[]{"Delete"};

    public UIRepositoryList() throws Exception {
        this.configure("name", REPO_BEAN_FIELD, REPO_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void updateGrid() throws Exception {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String defaultName = rservice.getConfig().getDefaultRepositoryName();
        ArrayList<RepoData> repos = new ArrayList<RepoData>();
        Iterator i$ = rservice.getConfig().getRepositoryConfigurations().iterator();
        while (i$.hasNext()) {
            RepositoryEntry obj;
            RepositoryEntry repo = obj = (RepositoryEntry)i$.next();
            StringBuilder sb = new StringBuilder();
            repo.getWorkspaceEntries();
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                sb.append(ws.getName()).append(";");
            }
            String name = repo.getName();
            String isDefault = String.valueOf(defaultName.equals(repo.getName()));
            String accessControl = repo.getAccessControl();
            String sessionTime = String.valueOf(repo.getSessionTimeOut());
            String workspace = sb.toString();
            repos.add(new RepoData(this, name, workspace, isDefault, accessControl, sessionTime));
        }
        ObjectPageList objPageList = new ObjectPageList(repos, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

