/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeList;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTreeList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITaxonomyTreeList.msg.confirm-delete"), @EventConfig(listeners={EditTaxonomyTreeActionListener.class}), @EventConfig(listeners={AddTaxonomyTreeActionListener.class})})
public class UITaxonomyTreeList
extends UIComponentDecorator {
    public static final String[] ACTIONS = new String[]{"AddTaxonomyTree"};
    public static final String ST_ADD = "AddTaxonomyTreePopup";
    public static final String ST_EDIT = "EditTaxonomyTreePopup";
    public static final String ACCESS_PERMISSION = "exo:accessPermissions";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UITaxonomyTreeListIterator");

    public UITaxonomyTreeList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public List getTaxonomyTreeList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateTaxonomyTreeListGrid(int currentPage) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getAllTaxonomyTreeList(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    private List<TaxonomyTreeData> getAllTaxonomyTreeList() throws RepositoryException {
        ArrayList<TaxonomyTreeData> lstTaxonomyTreeData = new ArrayList<TaxonomyTreeData>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List lstTaxonomyTreeNode = taxonomyService.getAllTaxonomyTrees(repository);
        if (lstTaxonomyTreeNode != null && lstTaxonomyTreeNode.size() > 0) {
            for (Node node : lstTaxonomyTreeNode) {
                lstTaxonomyTreeData.add(this.setData(node));
            }
        }
        return lstTaxonomyTreeData;
    }

    private TaxonomyTreeData setData(Node node) {
        TaxonomyTreeData taxonomyTreeData;
        block6: {
            taxonomyTreeData = null;
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            try {
                if (node == null) break block6;
                taxonomyTreeData = new TaxonomyTreeData();
                taxonomyTreeData.setTaxoTreeName(node.getName());
                taxonomyTreeData.setTaxoTreeHomePath(node.getPath());
                taxonomyTreeData.setTaxoTreeWorkspace(node.getSession().getWorkspace().getName());
                Node realTreeNode = taxonomyService.getTaxonomyTree(repository, node.getName(), true);
                Value[] values = realTreeNode.getProperty("exo:permissions").getValues();
                StringBuffer buffer = new StringBuffer(1024);
                try {
                    for (Value permission : values) {
                        buffer.append(permission.getString()).append(';');
                    }
                }
                catch (ValueFormatException e) {
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                String permission = buffer.toString();
                taxonomyTreeData.setTaxoTreePermissions(permission.substring(0, permission.length() - 1));
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return taxonomyTreeData;
    }
}

