/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionForm;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={PreviousViewPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={NextViewTreeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIDialogForm.OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIActionForm
extends UIDialogForm
implements UISelectable {
    private String parentPath_ = "";
    private String nodeTypeName_ = null;
    private boolean isAddNew_;
    private String scriptPath_ = null;
    private String rootPath_ = null;
    public static final String POPUP_COMPONENT = "PopupComponent";
    public static final String EXO_ACTIONS = "exo:actions".intern();
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIActionForm");

    public UIActionForm() throws Exception {
        this.setActions(new String[]{"PreviousViewPermission", "Save", "NextViewTree"});
    }

    public void createNewAction(Node parentNode, String actionType, boolean isAddNew) throws Exception {
        this.reset();
        this.nodeTypeName_ = actionType;
        this.isAddNew_ = isAddNew;
        this.componentSelectors.clear();
        this.properties.clear();
        this.getChildren().clear();
        if (parentNode != null) {
            this.parentPath_ = parentNode.getPath();
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIComponent uicomponent = this.getChildById(selectField);
        if (UIFormStringInput.class.isInstance(uicomponent)) {
            ((UIFormStringInput)uicomponent).setValue((Object)value.toString());
        } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
            ((UIFormMultiValueInputSet)uicomponent).setValue((List)((ArrayList)value));
        }
        UITaxonomyManagerTrees uiTaxoManageTree = (UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class);
        uiTaxoManageTree.removeChildById(POPUP_COMPONENT);
    }

    public String getCurrentPath() throws Exception {
        return this.parentPath_;
    }

    public void setCurrentPath(String path) {
        this.parentPath_ = path;
    }

    public String getWorkspace() {
        return this.getTaxoTreeData().getTaxoTreeWorkspace();
    }

    public String getRepositoryName() {
        return this.getTaxoTreeData().getRepository();
    }

    public TaxonomyTreeData getTaxoTreeData() {
        return ((UITaxonomyTreeContainer)this.getAncestorOfType(UITaxonomyTreeContainer.class)).getTaxonomyTreeData();
    }

    private String getTaxonomyTreeHomePath() throws Exception {
        TaxonomyTreeData taxoTreeData = this.getTaxoTreeData();
        String workspace = taxoTreeData.getTaxoTreeWorkspace();
        String homePath = taxoTreeData.getTaxoTreeHomePath();
        String systemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName(this.getRepositoryName());
        if (workspace.equals(systemWorkspace) && homePath.length() == 0) {
            homePath = this.getJcrPath("exoTaxoTreesStoragePath");
            taxoTreeData.setTaxoTreeHomePath(homePath);
        }
        return workspace + ":" + homePath;
    }

    private String getJcrPath(String path) {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath(path);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(this.getTaxoTreeData().getRepository()).getSystemWorkspace();
        return new JCRResourceResolver(this.getTaxoTreeData().getRepository(), workspace, "exo:templateFile");
    }

    public String getTemplate() {
        return this.getDialogPath();
    }

    public String getDialogPath() {
        this.repositoryName = this.getTaxoTreeData().getRepository();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String dialogPath = null;
        if (this.nodeTypeName_ != null) {
            try {
                dialogPath = templateService.getTemplatePathByUser(true, this.nodeTypeName_, userName, this.repositoryName);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return dialogPath;
    }

    public void onchange(Event<?> event) throws Exception {
        this.setIsUpdateSelect(false);
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        if ("homePath".equals(name)) {
            TaxonomyTreeData taxoTreeData = this.getTaxoTreeData();
            String homPath = this.getTaxonomyTreeHomePath();
            if (homPath.endsWith("/")) {
                homPath = homPath.substring(0, homPath.length() - 1);
            }
            ((UIFormStringInput)uiInput).setValue((Object)(homPath + "/" + taxoTreeData.getTaxoTreeName()));
        }
        if ("targetPath".equals(name) && this.isOnchange() && !this.isUpdateSelect) {
            ((UIFormStringInput)uiInput).reset();
        }
        super.renderField(name);
    }

    public String getTenmplateNodeType() {
        return this.nodeTypeName_;
    }

    public String getPath() {
        return this.scriptPath_;
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    private void setPermissionAction(Node currentNode) throws Exception {
        Session session = this.getSession();
        Node exoActionNode = currentNode.getNode(EXO_ACTIONS);
        if (PermissionUtil.canChangePermission((Node)exoActionNode)) {
            if (exoActionNode.canAddMixin("exo:privilegeable")) {
                exoActionNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            List<String> permsList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            String identity = null;
            for (AccessControlEntry accessEntry : ((ExtendedNode)currentNode).getACL().getPermissionEntries()) {
                identity = accessEntry.getIdentity();
                if (idList.contains(identity)) continue;
                idList.add(identity);
                permsList = ((ExtendedNode)currentNode).getACL().getPermissions(identity);
                if (SystemIdentity.SYSTEM.equals(identity)) {
                    if (!permsList.contains("remove")) {
                        permsList.add("remove");
                    }
                } else {
                    permsList.remove("remove");
                }
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
            }
            ((ExtendedNode)exoActionNode).setPermissions(perMap);
            currentNode.save();
            session.save();
            session.logout();
        }
    }

    static /* synthetic */ String access$000(UIActionForm x0, String x1) {
        return x0.getJcrPath(x1);
    }

    static /* synthetic */ String access$100(UIActionForm x0) {
        return x0.nodeTypeName_;
    }

    static /* synthetic */ void access$200(UIActionForm x0, Node x1) throws Exception {
        x0.setPermissionAction(x1);
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static /* synthetic */ boolean access$402(UIActionForm x0, boolean x1) {
        x0.isShowingComponent = x1;
        return x0.isShowingComponent;
    }

    static /* synthetic */ Map access$500(UIActionForm x0) {
        return x0.componentSelectors;
    }

    static /* synthetic */ boolean access$600(UIActionForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ boolean access$702(UIActionForm x0, boolean x1) {
        x0.isRemovePreference = x1;
        return x0.isRemovePreference;
    }
}

