/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UISkinTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIDialogTab.msg.confirm-delete")})
public class UISkinTab
extends UIContainer {
    private static final String[] BEAN_FIELD = new String[]{"name", "roles", "baseVersion"};
    private static final String[] ACTIONS = new String[]{"Edit", "Delete"};
    public static final String SKIN_LIST_NAME = "SkinList";
    public static final String SKIN_FORM_NAME = "SkinForm";
    private List<String> listSkin_ = new ArrayList();

    public UISkinTab() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, SKIN_LIST_NAME);
        uiGrid.getUIPageIterator().setId("SkinListIterator");
        uiGrid.configure("name", BEAN_FIELD, ACTIONS);
        UITemplateContent uiForm = (UITemplateContent)this.addChild(UITemplateContent.class, null, SKIN_FORM_NAME);
        uiForm.setTemplateType(TemplateService.SKINS);
        uiForm.update(null);
    }

    public void setTabRendered() {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.setRenderedChild(UISkinTab.class);
    }

    public List<String> getListSkin() {
        return this.listSkin_;
    }

    public void updateGrid(String nodeName, String repository) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Node templateHome = tempService.getTemplatesHome(repository, SessionProviderFactory.createSystemProvider()).getNode(nodeName);
        NodeIterator iter = templateHome.getNode(TemplateService.SKINS).getNodes();
        ArrayList<SkinData> data = new ArrayList<SkinData>();
        Node node = null;
        while (iter.hasNext()) {
            node = (Node)iter.next();
            String version = "";
            StringBuilder rule = new StringBuilder();
            Value[] rules = node.getProperty("exo:roles").getValues();
            for (int i = 0; i < rules.length; ++i) {
                rule.append("[" + rules[i].getString() + "]");
            }
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            this.listSkin_.add(node.getName());
            SkinData item = new SkinData(node.getName(), rule.toString(), version);
            data.add(item);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objDPageList = new ObjectPageList(data, 4);
        uiGrid.getUIPageIterator().setPageList((PageList)objDPageList);
    }
}

