/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import java.util.ArrayList;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagPermissionInfo;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITagPermissionInfo.msg.confirm-delete-permission")})
public class UITagPermissionInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups"};
    private static String[] PERMISSION_ACTION = new String[]{"Delete"};
    private int sizeOfListPermission = 0;

    public UITagPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "TagPermissionInfo");
        this.addChild((UIComponent)uiGrid);
        this.updateGrid();
        uiGrid.getUIPageIterator().setId("TagPermissionInfoIterator");
        uiGrid.configure(PERMISSION_BEAN_FIELD[0], PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.updateGrid();
        super.processRender(context);
    }

    public void updateGrid() throws Exception {
        ArrayList<TagPermissionData> tagPermissions = new ArrayList<TagPermissionData>();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        for (String usersOrGroups : newFolksonomyService.getTagPermissionList()) {
            tagPermissions.add(new TagPermissionData(usersOrGroups));
        }
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        int currentPage = uiGrid.getUIPageIterator().getCurrentPage();
        ObjectPageList objPageList = new ObjectPageList(tagPermissions, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
        int total = uiGrid.getUIPageIterator().getAvailablePage();
        uiGrid.getUIPageIterator().setCurrentPage(currentPage < total ? currentPage : total);
    }
}

