/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.TemplateBean;
import org.exoplatform.ecm.webui.component.admin.views.UICBTemplateList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UICBTemplateList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddActionListener.class})})
public class UICBTemplateList
extends UIGrid {
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "path", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"EditInfo", "Delete"};
    public static String ST_CBTempForm = "CBTempForm";
    public static String ST_CBTemp = "CBTemplate";

    public UICBTemplateList() throws Exception {
        this.getUIPageIterator().setId("UICBTemplateGrid");
        this.configure("path", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Add"};
    }

    public String getBaseVersion(Node node) throws Exception {
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public List<Node> getAllTemplates() throws Exception {
        ManageViewService viewService = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        ArrayList<Node> templateList = new ArrayList<Node>();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        templateList.addAll(viewService.getAllTemplates("cbDetaiViewTemplates", repository, provider));
        templateList.addAll(viewService.getAllTemplates("cbPathTemplates", repository, provider));
        templateList.addAll(viewService.getAllTemplates("cbQueryTemplates", repository, provider));
        templateList.addAll(viewService.getAllTemplates("cbScriptTemplates", repository, provider));
        return templateList;
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    public void updateCBTempListGrid(int currentPage) throws Exception {
        List nodes = this.getAllTemplates();
        ArrayList<TemplateBean> tempBeans = new ArrayList<TemplateBean>();
        for (Node node : nodes) {
            tempBeans.add(new TemplateBean(node.getName(), node.getPath(), this.getBaseVersion(node)));
        }
        Collections.sort(tempBeans, new CBViewComparator());
        this.getUIPageIterator().setPageList((PageList)new ObjectPageList(tempBeans, 10));
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(currentPage - 1);
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }
}

