/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.toolbar;

import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/Toolbar/UIAdminToolbarPortlet.gtmpl")
public class UIAdminToolbarPortlet
extends UIPortletApplication {
    public PageNavigation getSelectedNavigation() throws Exception {
        return Util.getUIPortal().getSelectedNavigation();
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        if (this.hasEditPermissionOnNavigation() || this.hasEditPermissionOnPage() || this.hasEditPermissionOnPortal()) {
            super.processRender(app, context);
        }
    }

    private boolean hasEditPermissionOnNavigation() throws Exception {
        PageNavigation selectedNavigation = this.getSelectedNavigation();
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (selectedNavigation == null || userACL == null) {
            return false;
        }
        if ("portal".equals(selectedNavigation.getOwnerType())) {
            return this.hasEditPermissionOnPortal();
        }
        return userACL.hasEditPermission(selectedNavigation);
    }

    private boolean hasEditPermissionOnPortal() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        return userACL.hasEditPermissionOnPortal(currentUIPortal.getOwnerType(), currentUIPortal.getOwner(), currentUIPortal.getEditPermission());
    }

    private boolean hasEditPermissionOnPage() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        UIPage uiPage = (UIPage)pageBody.getUIComponent();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (uiPage != null) {
            return userACL.hasEditPermissionOnPage(uiPage.getOwnerType(), uiPage.getOwnerId(), uiPage.getEditPermission());
        }
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        PageNode currentNode = currentUIPortal.getSelectedNode();
        String pageReference = currentNode.getPageReference();
        if (pageReference == null) {
            return false;
        }
        DataStorage dataStorage = (DataStorage)portalApp.getApplicationComponent(DataStorage.class);
        Page page = dataStorage.getPage(pageReference);
        if (page == null) {
            return false;
        }
        return userACL.hasEditPermission(page);
    }
}

