/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={PreferencesActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    public static final String PARAMETER_REGX = "(.*)/(.*)";
    private boolean isPrint = false;
    private PortletPreferences portletPreferences;
    private String contentParameter = null;

    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, null);
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.portletPreferences = portletRequestContext.getRequest().getPreferences();
    }

    public String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception e) {
                title = null;
            }
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public boolean isPrinting() {
        return this.isPrint;
    }

    public boolean isShowTitle() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_TITLE, "false"));
    }

    public boolean isShowDate() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_DATE, "false"));
    }

    public boolean isShowOptionBar() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.SHOW_OPTIONBAR, "false"));
    }

    public boolean isContextual() {
        return Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"));
    }

    public boolean isViewMode() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        System.out.println("VinhNT Tracert: isViewmode: " + portletRequestContext.getApplicationMode());
        return portletRequestContext.getApplicationMode().equals((Object)PortletMode.VIEW);
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return new SimpleDateFormat("dd.MM.yyyy '|' hh'h'mm").format(calendar.getTime());
        }
        return null;
    }

    public Node getNodeView() {
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        try {
            Node viewNode = this.getParameterizedNode();
            if (viewNode != null) {
                presentation.setNode(viewNode);
                presentation.setOriginalNode(viewNode);
                return viewNode;
            }
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            this.portletPreferences = portletRequestContext.getRequest().getPreferences();
            String repository = this.portletPreferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
            String workspace = this.portletPreferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
            String nodeIdentifier = this.portletPreferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
            viewNode = Utils.getRealNode((String)repository, (String)workspace, (String)nodeIdentifier, (boolean)false);
            presentation.setNode(viewNode);
            Node orgNode = Utils.getRealNode((String)repository, (String)workspace, (String)nodeIdentifier, (boolean)true);
            presentation.setOriginalNode(orgNode);
            return viewNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getParameterizedNode() throws Exception {
        PortalRequestContext preq = Util.getPortalRequestContext();
        if (!preq.useAjax()) {
            this.contentParameter = this.getRequestParameters();
        }
        if (this.contentParameter == null) {
            return null;
        }
        String strRepository = this.contentParameter.substring(0, this.contentParameter.indexOf("/"));
        UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
        Node nodeView = Utils.getViewableNodeByComposer(null, null, (String)this.contentParameter);
        if (nodeView != null) {
            boolean isDocumentType = false;
            if (nodeView.isNodeType("nt:frozenNode")) {
                isDocumentType = true;
            }
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            List documentTypes = templateService.getDocumentTemplates(strRepository);
            for (String documentType : documentTypes) {
                if (!nodeView.isNodeType(documentType)) continue;
                isDocumentType = true;
                break;
            }
            if (!isDocumentType) {
                return null;
            }
            if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
                String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
                presentation.setOriginalNode(nodeView.getSession().getNodeByUUID(nodeUUID));
                presentation.setNode(nodeView);
            } else {
                if (nodeView == null) {
                    return null;
                }
                presentation.setOriginalNode(nodeView);
                presentation.setNode(nodeView);
            }
            this.isPrint = Boolean.parseBoolean(Util.getPortalRequestContext().getRequestParameter("isPrint"));
        }
        return nodeView;
    }

    private String getRequestParameters() throws Exception {
        String parameters = null;
        if (!Boolean.parseBoolean(this.portletPreferences.getValue(UISingleContentViewerPortlet.CONTEXTUAL_MODE, "false"))) {
            return null;
        }
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)(Util.getUIPortal().getSelectedNode().getUri() + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String parameterName = this.portletPreferences.getValue(UISingleContentViewerPortlet.PARAMETER, "");
        if (!parameters.matches(PARAMETER_REGX)) {
            String path = Util.getPortalRequestContext().getRequestParameter(parameterName);
            if (path == null) {
                return null;
            }
            parameters = Util.getPortalRequestContext().getRequestParameter(parameterName).substring(1);
            return parameters;
        }
        return parameters;
    }

    public String getPrintUrl() throws RepositoryException {
        Node tempNode = this.getNodeView();
        String strPath = tempNode.getPath();
        String repository = ((ManageableRepository)tempNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = tempNode.getSession().getWorkspace().getName();
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String printPageUrl = wcmConfigurationService.getRuntimeContextParam("printViewerPage");
        String printUrl = portalURI + printPageUrl + "?path=/" + repository + "/" + workspace + strPath + "&isPrint=true";
        return printUrl;
    }

    public String getQuickEditLink() {
        return Utils.getEditLink((Node)this.getNodeView(), (boolean)true, (boolean)false);
    }
}

