/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.category.UICategoryNavigationPortlet;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.wcm.webui.category.config.UICategoryNavigationConfig;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={ChangeRepositoryActionListener.class}), @EventConfig(listeners={SelectTargetPathActionListener.class})})
public class UICategoryNavigationConfig
extends UIForm
implements UISelectable {
    private String popupId;

    public UICategoryNavigationConfig() throws Exception {
        PortletPreferences preferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceRepository = preferences.getValue("repository", "");
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList<SelectItemOption> repositories = new ArrayList<SelectItemOption>();
        RepositoryEntry repositoryEntry = repositoryService.getCurrentRepository().getConfiguration();
        repositories.add(new SelectItemOption((Object)repositoryEntry.getName()));
        UIFormSelectBox repositoryFormSelectBox = new UIFormSelectBox("UICategoryNavigationRepositoryFormSelectBox", "UICategoryNavigationRepositoryFormSelectBox", repositories);
        repositoryFormSelectBox.setValue(preferenceRepository);
        repositoryFormSelectBox.setOnChange("ChangeRepository");
        this.addUIFormInput((UIFormInput)repositoryFormSelectBox);
        String preferenceTreeTitle = preferences.getValue("treeTitle", "");
        this.addUIFormInput((UIFormInput)new UIFormStringInput("UICategoryNavigationTreeTitleFormStringInput", "UICategoryNavigationTreeTitleFormStringInput", preferenceTreeTitle));
        String preferenceTreeName = preferences.getValue("treeName", "");
        List trees = this.getTaxonomyTrees(preferenceRepository);
        UIFormSelectBox treeNameFormSelectBox = new UIFormSelectBox("UICategoryNavigationTreeNameFormSelectBox", "UICategoryNavigationTreeNameFormSelectBox", trees);
        treeNameFormSelectBox.setValue(preferenceTreeName);
        this.addUIFormInput((UIFormInput)treeNameFormSelectBox);
        String preferencePortletName = preferences.getValue("portletName", "");
        String preferenceTemplateCategory = preferences.getValue("templateCategory", "");
        String preferenceTemplatePath = preferences.getValue("templatePath", "");
        List templates = this.getTemplateList(preferencePortletName, preferenceTemplateCategory);
        UIFormSelectBox templateFormSelectBox = new UIFormSelectBox("UICategoryNavigationTemplateFormSelectBox", "UICategoryNavigationTemplateFormSelectBox", templates);
        templateFormSelectBox.setValue(preferenceTemplatePath);
        this.addUIFormInput((UIFormInput)templateFormSelectBox);
        String preferenceTargetPath = preferences.getValue("targetPath", "");
        UIFormInputSetWithAction targetPathFormInputSet = new UIFormInputSetWithAction("UICategoryNavigationTargetPathFormInputSet");
        UIFormStringInput targetPathFormStringInput = new UIFormStringInput("UICategoryNavigationTargetPathFormStringInput", "UICategoryNavigationTargetPathFormStringInput", preferenceTargetPath);
        targetPathFormStringInput.setEditable(false);
        targetPathFormInputSet.setActionInfo("UICategoryNavigationTargetPathFormStringInput", new String[]{"SelectTargetPath"});
        targetPathFormInputSet.addUIFormInput((UIFormInput)targetPathFormStringInput);
        this.addChild((UIComponent)targetPathFormInputSet);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String templateCategory) throws Exception {
        ArrayList<SelectItemOption<String>> templates = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        ApplicationTemplateManagerService applicationTemplateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodes = applicationTemplateManagerService.getTemplatesByCategory(repository, portletName, templateCategory, Utils.getSessionProvider());
        for (Node templateNode : templateNodes) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templates.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templates;
    }

    private List<SelectItemOption<String>> getTaxonomyTrees(String repository) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        List taxonomyNodes = taxonomyService.getAllTaxonomyTrees(repository);
        ArrayList<SelectItemOption<String>> taxonomyTrees = new ArrayList<SelectItemOption<String>>();
        for (Node taxonomyNode : taxonomyNodes) {
            Node portalNode = livePortalManagerService.getLivePortalByChild(taxonomyNode);
            if (portalNode == null) continue;
            taxonomyTrees.add((SelectItemOption<String>)new SelectItemOption(taxonomyNode.getName(), (Object)taxonomyNode.getName()));
        }
        return taxonomyTrees;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIFormStringInput formStringInput = (UIFormStringInput)this.findComponentById(selectField);
        formStringInput.setValue((Object)value.toString());
        UICategoryNavigationPortlet categoryNavigationPortlet = (UICategoryNavigationPortlet)this.getAncestorOfType(UICategoryNavigationPortlet.class);
        UIPopupContainer popupContainer = (UIPopupContainer)categoryNavigationPortlet.getChild(UIPopupContainer.class);
        Utils.closePopupWindow((UIContainer)popupContainer, (String)this.popupId);
    }
}

