/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIPCVContainer;
import org.exoplatform.wcm.webui.pcv.UIPCVPortlet;
import org.exoplatform.wcm.webui.pcv.UIPCVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ParameterizedContentViewer/UIPCVContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class}), @EventConfig(listeners={EditActionListener.class})})
public class UIPCVContainer
extends UIContainer {
    private boolean isDraftRevision = false;
    private boolean isObsoletedContent = false;
    private UIPCVPresentation uiContentViewer;
    private String repository;
    private boolean isPrint;
    public static final String PREFERENCE_REPOSITORY = "repository";
    private DateFormat dateFormatter = null;

    public UIPCVContainer() throws Exception {
        this.addChild(UIPCVPresentation.class, null, null);
        this.uiContentViewer = (UIPCVPresentation)this.getChild(UIPCVPresentation.class);
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.repository = porletRequestContext.getRequest().getPreferences().getValue(PREFERENCE_REPOSITORY, "");
        this.dateFormatter = new SimpleDateFormat();
        ((SimpleDateFormat)this.dateFormatter).applyPattern("dd.MM.yyyy '|' hh'h'mm");
    }

    public boolean isShowTitle() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showTitle", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        return portletPreferences;
    }

    public String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception e) {
                title = null;
            }
        }
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public boolean isShowDateCreated() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showDateCreated", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public boolean isShowBar() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue("showBar", null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getRepository() throws RepositoryException {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public Node getNode() throws Exception {
        String parameters = this.getRequestParameters();
        Node nodeView = Utils.getViewableNodeByComposer(null, null, (String)parameters);
        if (nodeView != null) {
            boolean isDocumentType = false;
            if (nodeView.isNodeType("nt:frozenNode")) {
                isDocumentType = true;
            }
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            List documentTypes = templateService.getDocumentTemplates();
            for (String documentType : documentTypes) {
                if (!nodeView.isNodeType(documentType)) continue;
                isDocumentType = true;
                break;
            }
            if (!isDocumentType) {
                return null;
            }
            if (this.hasChildren()) {
                this.removeChild(UIPCVContainer.class);
            }
            if (nodeView != null && nodeView.isNodeType("nt:frozenNode")) {
                String nodeUUID = nodeView.getProperty("jcr:frozenUuid").getString();
                this.uiContentViewer.setOriginalNode(nodeView.getSession().getNodeByUUID(nodeUUID));
                this.uiContentViewer.setNode(nodeView);
            } else {
                if (nodeView == null) {
                    return null;
                }
                this.uiContentViewer.setOriginalNode(nodeView);
                this.uiContentViewer.setNode(nodeView);
            }
            this.uiContentViewer.setRepository(this.getRepository());
            this.uiContentViewer.setWorkspace(nodeView.getSession().getWorkspace().getName());
            this.isPrint = Boolean.parseBoolean(Util.getPortalRequestContext().getRequestParameter("isPrint"));
        }
        return nodeView;
    }

    private String getRequestParameters() throws Exception {
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)(Util.getUIPortal().getSelectedNode().getUri() + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        if (!parameters.matches("(.*)/(.*)")) {
            String path = Util.getPortalRequestContext().getRequestParameter("path");
            if (path == null) {
                return ((UIPCVPortlet)this.getAncestorOfType(UIPCVPortlet.class)).getCurrentNodePath();
            }
            parameters = Util.getPortalRequestContext().getRequestParameter("path").substring(1);
            return parameters;
        }
        return parameters;
    }

    public boolean getIsPrint() {
        return this.isPrint;
    }

    public void setIsPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isDraftRevision() {
        return this.isDraftRevision;
    }

    public void setDraftRevision(boolean isDraftRevision) {
        this.isDraftRevision = isDraftRevision;
    }

    public boolean isObsoletedContent() {
        return this.isObsoletedContent;
    }

    public void setObsoletedContent(boolean isObsoletedContent) {
        this.isObsoletedContent = isObsoletedContent;
    }
}

