/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})})
public class UICategoryNavigationTreeBase
extends UITree {
    public String renderNode(Object obj) throws Exception {
        String beanIconField;
        Node node = (Node)obj;
        String nodeTypeIcon = Utils.getNodeTypeIcon((Node)node, (String)"16x16Icon");
        String nodeIcon = this.getExpandIcon();
        String iconGroup = this.getIcon();
        String note = "";
        if (this.isSelected(obj)) {
            nodeIcon = this.getColapseIcon();
            iconGroup = this.getSelectedIcon();
            note = " NodeSelected";
        }
        if ((beanIconField = this.getBeanIconField()) != null && beanIconField.length() > 0 && this.getFieldValue(obj, beanIconField) != null) {
            iconGroup = (String)this.getFieldValue(obj, beanIconField);
        }
        this.renderCategoryLink(node);
        String objId = String.valueOf(this.getId(obj));
        StringBuilder builder = new StringBuilder();
        if (nodeIcon.equals(this.getExpandIcon())) {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" href=\"").append(objId).append("\">");
        } else {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" onclick=\"eXo.portal.UIPortalControl.collapseTree(this)").append("\">");
        }
        UIRightClickPopupMenu popupMenu = this.getUiPopupMenu();
        String beanLabelField = this.getBeanLabelField();
        String className = "NodeIcon";
        boolean flgSymlink = false;
        if (Utils.isSymLink((Node)node)) {
            flgSymlink = true;
            className = "NodeIconLink";
        }
        if (popupMenu == null) {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\"").append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        } else {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\" ").append(popupMenu.getJSOnclickShowPopup(objId, null)).append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        }
        builder.append(" </a>");
        return builder.toString();
    }

    public String getTemplate() {
        return UICategoryNavigationUtils.getPortletPreferences().getValue("templatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public String getActionLink() throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String preferenceTargetPage = portletPreferences.getValue("targetPath", "");
        String backPath = requestURI.substring(0, requestURI.lastIndexOf("/"));
        if (backPath.endsWith(preferenceTargetPage) || requestURI.endsWith(Util.getUIPortal().getSelectedUserNode().getURI())) {
            backPath = "javascript:void(0)";
        } else if (backPath.endsWith(preferenceTreeName)) {
            backPath = backPath.substring(0, backPath.lastIndexOf("/"));
        }
        return backPath;
    }

    public boolean isSelected(Object obj) throws Exception {
        Node selectedNode = (Node)this.getSelected();
        Node node = (Node)obj;
        if (selectedNode == null) {
            return false;
        }
        return selectedNode.getPath().equals(node.getPath());
    }

    public boolean isMovedTreeToTrash(String rootCategory) throws Exception {
        Node categoryNode = this.getCategoryNode(rootCategory);
        return Utils.isInTrash((Node)categoryNode);
    }

    public List<Node> getSubcategories(String categoryPath) throws Exception {
        Node categoryNode = this.getCategoryNode(categoryPath);
        NodeIterator nodeIterator = categoryNode.getNodes();
        ArrayList<Node> subcategories = new ArrayList<Node>();
        while (nodeIterator.hasNext()) {
            Node subcategory = nodeIterator.nextNode();
            if (!subcategory.isNodeType("exo:taxonomy")) continue;
            subcategories.add(subcategory);
        }
        return subcategories;
    }

    public String resolveCategoryPathByUri(WebuiRequestContext context) throws Exception {
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)Util.getUIPortal().getSelectedUserNode().getURI()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String categoryPath = parameters.indexOf("/") >= 0 ? parameters.substring(parameters.indexOf("/")) : "";
        String gpath = Util.getPortalRequestContext().getRequestParameter("path");
        if (gpath != null) {
            PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
            String preferenceTreeName = portletPreferences.getValue("treeName", "");
            categoryPath = gpath.substring(gpath.indexOf(preferenceTreeName) + preferenceTreeName.length());
        }
        return categoryPath;
    }

    public List<String> getCategoriesByUri(String categoryUri) throws Exception {
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        if (preferenceTreeName.equals(categoryUri)) {
            categoryUri = "";
        }
        ArrayList<String> categories = new ArrayList<String>();
        String[] tempCategories = categoryUri.split("/");
        String tempCategory = "";
        for (int i = 0; i < tempCategories.length; ++i) {
            tempCategory = i == 0 ? "" : (i == 1 ? tempCategories[1] : tempCategory + "/" + tempCategories[i]);
            categories.add(tempCategory);
        }
        return categories;
    }

    public String renderCategoryLink(Node node) throws Exception {
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTargetPage = portletPreferences.getValue("targetPath", "");
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        Node portalNode = livePortalManagerService.getLivePortalByChild(node);
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String categoryPath = node.getPath().replaceFirst(portalNode.getPath(), "");
        categoryPath = categoryPath.substring(categoryPath.indexOf(preferenceTreeName) - 1);
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), preferenceTargetPage);
        nodeURL.setResource(resource).setQueryParameterValue("path", categoryPath);
        String link = nodeURL.toString();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public String getTitle(Node node) throws Exception {
        if (node.hasProperty("exo:title")) {
            return node.getProperty("exo:title").getString();
        }
        return node.getName();
    }

    public String getTreeTitle() {
        return UICategoryNavigationUtils.getPortletPreferences().getValue("treeTitle", "");
    }

    private Node getCategoryNode(String categoryPath) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        Node treeNode = taxonomyService.getTaxonomyTree(preferenceTreeName);
        Node categoryNode = null;
        categoryNode = "".equals(categoryPath) ? treeNode : treeNode.getNode(categoryPath);
        return categoryNode;
    }
}

