/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.PaginatedResultIterator;
import org.exoplatform.services.wcm.publication.Result;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVContainer.gtmpl", events={@EventConfig(listeners={UICLVContainer.PreferencesActionListener.class})})
public class UICLVFolderMode
extends UICLVContainer {
    private UICLVPresentation clvPresentation;

    public void init() throws Exception {
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        Result result = null;
        this.messageKey = null;
        try {
            result = this.getRenderedContentNodes();
        }
        catch (ItemNotFoundException e) {
            this.messageKey = "UICLVContainer.msg.item-not-found";
            return;
        }
        catch (AccessDeniedException e) {
            this.messageKey = "UICLVContainer.msg.no-permission";
            return;
        }
        if (result.getNumTotal() == 0L) {
            this.messageKey = "UICLVContainer.msg.non-contents";
        }
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedResultIterator paginatedResultIterator = new PaginatedResultIterator(result, itemsPerPage);
        this.getChildren().clear();
        this.clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        this.clvPresentation.init(resourceResolver, (PageList)paginatedResultIterator);
    }

    public Result getRenderedContentNodes() throws Exception {
        NodeLocation nodeLocation;
        String folderPath;
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.getCurrentMode());
        String orderBy = preferences.getValue("orderBy", null);
        String orderType = preferences.getValue("orderType", null);
        String itemsPerPage = preferences.getValue("itemsPerPage", null);
        String sharedCache = preferences.getValue("sharedCache", "true");
        String contextualMode = preferences.getValue("contextualFolder", "true");
        String workspace = preferences.getValue("workspace", null);
        String query = preferences.getValue("query", null);
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        filters.put("filter-language", Util.getPortalRequestContext().getLocale().getLanguage());
        filters.put("filter-limit", itemsPerPage);
        filters.put("filter-visibility", "true".equals(sharedCache) ? "public" : "user");
        if (((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).isQueryApplication()) {
            folderPath = preferences.getValue("folderPath", null);
            if (folderPath == null) {
                return new Result(new ArrayList(), 0L, 0L, null, null);
            }
            nodeLocation = new NodeLocation();
            nodeLocation.setWorkspace(workspace);
            nodeLocation.setPath("/");
            nodeLocation.setSystemSession(false);
            String strQuery = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getQueryStatement(query);
            strQuery = strQuery.replaceAll("\"", "'");
            if ("contextualEnable".equals(contextualMode) && Utils.checkQuery((String)workspace, (String)strQuery, (String)"sql")) {
                filters.put("filter-query-full", strQuery);
                return wcmComposer.getPaginatedContents(nodeLocation, filters, WCMCoreUtils.getUserSessionProvider());
            }
        }
        nodeLocation = NodeLocation.getNodeLocationByExpression((String)((folderPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath()) != null ? folderPath : preferences.getValue("folderPath", null)));
        if (folderPath == null && preferences.getValue("folderPath", null) == null) {
            return new Result(new ArrayList(), 0L, 0L, null, null);
        }
        String nPath = new String(nodeLocation.getPath().getBytes("ISO-8859-1"), "UTF-8");
        return wcmComposer.getPaginatedContents(nodeLocation, filters, WCMCoreUtils.getUserSessionProvider());
    }

    public boolean isShowInfoBar() throws Exception {
        return UIPortlet.getCurrentUIPortlet().getShowInfoBar();
    }
}

