/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.util.Date;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIPCVContainer;
import org.exoplatform.wcm.webui.pcv.config.UIPCVConfig;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.w3c.dom.Element;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIPCVPortlet
extends UIPortletApplication {
    public static final String QUICK_EDIT_ABLE = "quickEditable";
    public static final String PCV_CONFIG_POPUP_WINDOW = "UIPCVConfigPopupWindow";
    public static final String PREFERENCE_REPOSITORY = "repository";
    public static final String WORKSPACE = "workspace";
    public static final String SHOW_TITLE = "showTitle";
    public static final String SHOW_DATE_CREATED = "showDateCreated";
    public static final String SHOW_BAR = "showBar";
    private String currentNodePath;
    private PortletMode mode = PortletMode.VIEW;

    public UIPCVPortlet() throws Exception {
        this.activateMode(this.mode);
    }

    public void activateMode(PortletMode mode) throws Exception {
        this.getChildren().clear();
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + new Date().getTime());
        if (PortletMode.VIEW.equals((Object)mode)) {
            this.addChild(UIPCVContainer.class, null, null);
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            this.addChild(UIPCVConfig.class, null, null);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        UIPCVContainer container;
        PortletRequestContext pContext;
        PortletMode newMode;
        if (Util.getPortalRequestContext().getRequestParameter("path") != null) {
            this.setCurrentNodePath(Util.getPortalRequestContext().getRequestParameter("path").substring(1));
        }
        if (!this.mode.equals((Object)(newMode = (pContext = (PortletRequestContext)context).getApplicationMode()))) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        if ((container = (UIPCVContainer)this.getChild(UIPCVContainer.class)) != null && container.getNode() != null) {
            RenderResponse response = (RenderResponse)context.getResponse();
            Element title = response.createElement("title");
            title.setTextContent(container.getTitle(container.getNode()));
            response.addProperty("javax.portlet.markup.head.element", title);
        }
        super.processRender(app, context);
    }

    public boolean canEditPortlet() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String userId = context.getRemoteUser();
        return Utils.canEditCurrentPortal((String)userId);
    }

    public String getCurrentNodePath() {
        return this.currentNodePath;
    }

    public void setCurrentNodePath(String currentNodePath) {
        this.currentNodePath = currentNodePath;
    }
}

