/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVConfig;
import org.exoplatform.wcm.webui.validator.ZeroNumberValidator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/ContentListViewer/UICLVConfig.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectFolderPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={IncreaseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DecreaseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowAdvancedBlockActionListener.class}, phase=Event.Phase.DECODE)})
public class UICLVConfig
extends UIForm
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)UICLVConfig.class.getName());
    public static final String DISPLAY_MODE_FORM_RADIO_BOX_INPUT = "UICLVConfigDisplayModeFormRadioBoxInput";
    public static final String ITEM_PATH_FORM_INPUT_SET = "UICLVConfigItemPathFormInputSet";
    public static final String ITEM_PATH_FORM_STRING_INPUT = "UICLVConfigItemPathFormStringInput";
    public static final String ORDER_BY_FORM_SELECT_BOX = "UICLVConfigOrderByFormSelectBox";
    public static final String ORDER_TYPE_FORM_RADIO_BOX_INPUT = "UICLVConfigOrderTypeFormRadioBoxInput";
    public static final String HEADER_FORM_STRING_INPUT = "UICLVConfigHeaderFormStringInput";
    public static final String SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT = "UICLVConfigShowAutomaticDetectionCheckboxInput";
    public static final String DISPLAY_TEMPLATE_FORM_SELECT_BOX = "UICLVConfigDisplayTemplateFormSelectBox";
    public static final String PAGINATOR_TEMPLATE_FORM_SELECT_BOX = "UICLVConfigPaginatorTemplateFormSelectBox";
    public static final String ITEMS_PER_PAGE_FORM_STRING_INPUT = "UICLVConfigItemsPerPageFormStringInput";
    public static final String SHOW_TITLE_FORM_CHECKBOX_INPUT = "UICLVConfigShowTitleFormCheckboxInput";
    public static final String SHOW_HEADER_FORM_CHECKBOX_INPUT = "UICLVConfigShowHeaderFormCheckboxInput";
    public static final String SHOW_REFRESH_FORM_CHECKBOX_INPUT = "UICLVConfigShowRefreshFormCheckboxInput";
    public static final String SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT = "UICLVConfigShowIllustrationFormCheckboxInput";
    public static final String SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT = "UICLVConfigShowDateCreatedFormCheckboxInput";
    public static final String SHOW_READMORE_FORM_CHECKBOX_INPUT = "UICLVConfigShowReadmoreFormCheckboxInput";
    public static final String SHOW_SUMMARY_FORM_CHECKBOX_INPUT = "UICLVConfigShowSummaryFormCheckboxInput";
    public static final String SHOW_LINK_FORM_CHECKBOX_INPUT = "UICLVConfigShowLinkFormCheckboxInput";
    public static final String SHOW_RSSLINK_FORM_CHECKBOX_INPUT = "UICLVConfigShowRssLinkFormCheckboxInput";
    public static final String TARGET_PAGE_FORM_INPUT_SET = "UICLVConfigTargetPageFormInputSet";
    public static final String TARGET_PAGE_FORM_STRING_INPUT = "UICLVConfigTargetPageFormStringInput";
    public static final String TARGET_PAGE_SELECTOR_POPUP_WINDOW = "UICLVConfigTargetPageSelectorPopupWindow";
    public static final String DYNAMIC_NAVIGATION_LABEL = "UICLVConfigDynamicNavigationLabel";
    public static final String CONTEXTUAL_FOLDER_RADIOBOX_INPUT = "UICLVConfigContextualFolderRadioBoxInput";
    public static final String SHOW_CLV_BY_STRING_INPUT = "UICLVConfigShowCLVByStringInput";
    public static final String SHOW_SCV_WITH_STRING_INPUT = "UICLVConfigshowSCVWithStringInput";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String CACHE_ENABLE_RADIOBOX_INPUT = "UICLVConfigCacheEnableRadioBoxInput";
    public static final String CONTENT_BY_QUERY_TEXT_AREA = "UICLVConfigContentByQueryTextArea";
    public static final String WORKSPACE_FORM_SELECT_BOX = "UICLVConfigWorkspaceFormSelectBox";
    public static final String CACHE_MANAGEMENT_LABEL = "UICLVConfigCacheManagementLabel";
    public static final String CONTENT_BY_QUERY_LABEL = "UICLVContentByQueryLabel";
    public static final String DISPLAY_TEMPLATE_CATEGORY = "navigation";
    public static final String DISPLAY_TEMPLATE_LIST = "list";
    public static final String TEMPLATE_STORAGE_FOLDER = "content-list-viewer";
    public static final String CONTENT_LIST_TYPE = "ContentList";
    public static final String CATEGORIES_CONTENT_TYPE = "CategoryContents";
    public static final String CATOGORIES_NAVIGATION_TYPE = "CategoryNavigation";
    public static final String ENABLE_CACHE = "ENABLE";
    public static final String DISABLE_CACHE = "DISABLE";
    private String popupId;
    private List<String> items;
    private String savedPath;
    private boolean isShowAdvancedBlock_;
    private String appType;
    private String driveName_;
    private boolean modeInternal = false;

    public void setSavedPath(String value) {
        this.savedPath = value;
    }

    public String getSavedPath() {
        return this.savedPath;
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public void setDriveName(String value) {
        this.driveName_ = value;
    }

    public String getDriveName() {
        return this.driveName_;
    }

    public List<String> getItems() {
        String displayMode = (String)((UIFormRadioBoxInput)this.getChildById(DISPLAY_MODE_FORM_RADIO_BOX_INPUT)).getValue();
        String itemPath = Utils.getPortletPreference((String)"folderPath");
        if (this.items == null && "ManualViewerMode".equals(displayMode) && itemPath != null && itemPath.contains(";")) {
            this.items = Arrays.asList(itemPath.split(";"));
        }
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public boolean isShowAdvancedBlock() {
        return this.isShowAdvancedBlock_;
    }

    public void setIsShowAdvancedBlock(boolean value) {
        this.isShowAdvancedBlock_ = value;
    }

    public UICLVConfig() throws Exception {
        String[] workspaceList;
        String itemPath;
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        this.appType = portletPreferences.getValue("application", null);
        String displayMode = portletPreferences.getValue("mode", null);
        this.savedPath = itemPath = portletPreferences.getValue("folderPath", null);
        itemPath = this.getTitles(this.savedPath);
        this.setDriveName(portletPreferences.getValue("nodeDrive", null));
        String orderBy = portletPreferences.getValue("orderBy", null);
        String orderType = portletPreferences.getValue("orderType", null);
        String header = portletPreferences.getValue("header", null);
        String displayTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        String contextualFolderMode = portletPreferences.getValue("contextualFolder", null);
        String showClvBy = portletPreferences.getValue("showClvBy", null);
        String targetPage = portletPreferences.getValue("basePath", null);
        String showScvWith = portletPreferences.getValue("showScvWith", null);
        String isCacheEnabled = portletPreferences.getValue("sharedCache", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String contentByQuery = portletPreferences.getValue("query", null);
        boolean showAutomaticDetection = Boolean.parseBoolean(portletPreferences.getValue("automaticDetection", null));
        boolean showTitle = Boolean.parseBoolean(portletPreferences.getValue("showTitle", null));
        boolean showHeader = Boolean.parseBoolean(portletPreferences.getValue("showHeader", null));
        boolean showRefresh = Boolean.parseBoolean(portletPreferences.getValue("showRefreshButton", null));
        boolean showImage = Boolean.parseBoolean(portletPreferences.getValue("showThumbnailsView", null));
        boolean showDateCreated = Boolean.parseBoolean(portletPreferences.getValue("showDateCreated", null));
        boolean showReadmore = Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null));
        boolean showSummary = Boolean.parseBoolean(portletPreferences.getValue("showSummary", null));
        boolean showLink = Boolean.parseBoolean(portletPreferences.getValue("showLink", null));
        boolean showRssLink = Boolean.parseBoolean(portletPreferences.getValue("showRssLink", null));
        ArrayList<SelectItemOption> displayModeOptions = new ArrayList<SelectItemOption>();
        displayModeOptions.add(new SelectItemOption("AutoViewerMode", (Object)"AutoViewerMode"));
        displayModeOptions.add(new SelectItemOption("ManualViewerMode", (Object)"ManualViewerMode"));
        UIFormRadioBoxInput displayModeRadioBoxInput = new UIFormRadioBoxInput(DISPLAY_MODE_FORM_RADIO_BOX_INPUT, DISPLAY_MODE_FORM_RADIO_BOX_INPUT, displayModeOptions);
        displayModeRadioBoxInput.setValue((Object)displayMode);
        UIFormStringInput itemPathInput = new UIFormStringInput(ITEM_PATH_FORM_STRING_INPUT, ITEM_PATH_FORM_STRING_INPUT, itemPath);
        itemPathInput.setEditable(false);
        itemPathInput.setDisabled(true);
        itemPathInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormInputSetWithAction itemPathInputSet = new UIFormInputSetWithAction(ITEM_PATH_FORM_INPUT_SET);
        itemPathInputSet.setActionInfo(ITEM_PATH_FORM_STRING_INPUT, new String[]{"SelectFolderPath"});
        itemPathInputSet.addUIFormInput((UIFormInput)itemPathInput);
        ArrayList<SelectItemOption> orderByOptions = new ArrayList<SelectItemOption>();
        orderByOptions.add(new SelectItemOption("OrderByTitle", (Object)"exo:title"));
        orderByOptions.add(new SelectItemOption("OrderByDateCreated", (Object)"exo:dateCreated"));
        orderByOptions.add(new SelectItemOption("OrderByDateModified", (Object)"exo:dateModified"));
        orderByOptions.add(new SelectItemOption("OrderByDatePublished", (Object)"publication:liveDate"));
        orderByOptions.add(new SelectItemOption("OrderByDateStartEvent", (Object)"exo:startEvent"));
        orderByOptions.add(new SelectItemOption("OrderByIndex", (Object)"exo:index"));
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox(ORDER_BY_FORM_SELECT_BOX, ORDER_BY_FORM_SELECT_BOX, orderByOptions);
        orderBySelectBox.setValue(orderBy);
        ArrayList<SelectItemOption> orderTypeOptions = new ArrayList<SelectItemOption>();
        orderTypeOptions.add(new SelectItemOption("OrderDesc", (Object)"DESC"));
        orderTypeOptions.add(new SelectItemOption("OrderAsc", (Object)"ASC"));
        UIFormRadioBoxInput orderTypeRadioBoxInput = new UIFormRadioBoxInput(ORDER_TYPE_FORM_RADIO_BOX_INPUT, ORDER_TYPE_FORM_RADIO_BOX_INPUT, orderTypeOptions);
        orderTypeRadioBoxInput.setValue((Object)orderType);
        UIFormStringInput headerInput = new UIFormStringInput(HEADER_FORM_STRING_INPUT, HEADER_FORM_STRING_INPUT, header);
        UIFormCheckBoxInput showAutomaticDetectionCheckBox = new UIFormCheckBoxInput(SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT, SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT, null);
        showAutomaticDetectionCheckBox.setChecked(showAutomaticDetection);
        ArrayList formViewerTemplateList = new ArrayList();
        ArrayList viewerTemplateList = new ArrayList();
        if (this.appType.equals(CONTENT_LIST_TYPE) || this.appType.equals(CATEGORIES_CONTENT_TYPE) || this.appType.equals("ContentsByQuery")) {
            viewerTemplateList.addAll(this.getTemplateList(TEMPLATE_STORAGE_FOLDER, DISPLAY_TEMPLATE_LIST));
        }
        if (this.appType.equals(CONTENT_LIST_TYPE) || this.appType.equals(CATOGORIES_NAVIGATION_TYPE)) {
            viewerTemplateList.addAll(this.getTemplateList(TEMPLATE_STORAGE_FOLDER, DISPLAY_TEMPLATE_CATEGORY));
        }
        Collections.sort(viewerTemplateList, new TemplateNameComparator(this, null));
        formViewerTemplateList.addAll(viewerTemplateList);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox(DISPLAY_TEMPLATE_FORM_SELECT_BOX, DISPLAY_TEMPLATE_FORM_SELECT_BOX, formViewerTemplateList);
        formViewTemplateSelector.setValue(displayTemplate);
        List paginatorTemplateList = this.getTemplateList(TEMPLATE_STORAGE_FOLDER, PAGINATOR_TEMPLATE_CATEGORY);
        Collections.sort(paginatorTemplateList, new TemplateNameComparator(this, null));
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox(PAGINATOR_TEMPLATE_FORM_SELECT_BOX, PAGINATOR_TEMPLATE_FORM_SELECT_BOX, paginatorTemplateList);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        UIFormStringInput itemsPerPageStringInput = new UIFormStringInput(ITEMS_PER_PAGE_FORM_STRING_INPUT, ITEMS_PER_PAGE_FORM_STRING_INPUT, itemsPerPage);
        itemsPerPageStringInput.addValidator(MandatoryValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(ZeroNumberValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        itemsPerPageStringInput.setMaxLength(3);
        UIFormCheckBoxInput showTitleCheckbox = new UIFormCheckBoxInput(SHOW_TITLE_FORM_CHECKBOX_INPUT, SHOW_TITLE_FORM_CHECKBOX_INPUT, null);
        showTitleCheckbox.setChecked(showTitle);
        UIFormCheckBoxInput showHeaderCheckBox = new UIFormCheckBoxInput(SHOW_HEADER_FORM_CHECKBOX_INPUT, SHOW_HEADER_FORM_CHECKBOX_INPUT, null);
        showHeaderCheckBox.setChecked(showHeader);
        UIFormCheckBoxInput showRefreshCheckbox = new UIFormCheckBoxInput(SHOW_REFRESH_FORM_CHECKBOX_INPUT, SHOW_REFRESH_FORM_CHECKBOX_INPUT, null);
        showRefreshCheckbox.setChecked(showRefresh);
        UIFormCheckBoxInput showImageCheckbox = new UIFormCheckBoxInput(SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT, SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT, null);
        showImageCheckbox.setChecked(showImage);
        UIFormCheckBoxInput showDateCreatedCheckbox = new UIFormCheckBoxInput(SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT, SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT, null);
        showDateCreatedCheckbox.setChecked(showDateCreated);
        UIFormCheckBoxInput showMoreLinkCheckbox = new UIFormCheckBoxInput(SHOW_READMORE_FORM_CHECKBOX_INPUT, SHOW_READMORE_FORM_CHECKBOX_INPUT, null);
        showMoreLinkCheckbox.setChecked(showReadmore);
        UIFormCheckBoxInput showSummaryCheckbox = new UIFormCheckBoxInput(SHOW_SUMMARY_FORM_CHECKBOX_INPUT, SHOW_SUMMARY_FORM_CHECKBOX_INPUT, null);
        showSummaryCheckbox.setChecked(showSummary);
        UIFormCheckBoxInput showLinkCheckbox = new UIFormCheckBoxInput(SHOW_LINK_FORM_CHECKBOX_INPUT, SHOW_LINK_FORM_CHECKBOX_INPUT, null);
        showLinkCheckbox.setChecked(showLink);
        UIFormCheckBoxInput showRssLinkCheckbox = new UIFormCheckBoxInput(SHOW_RSSLINK_FORM_CHECKBOX_INPUT, SHOW_RSSLINK_FORM_CHECKBOX_INPUT, null);
        showRssLinkCheckbox.setChecked(showRssLink);
        ArrayList<SelectItemOption> contextualFolderOptions = new ArrayList<SelectItemOption>();
        contextualFolderOptions.add(new SelectItemOption("contextualEnable", (Object)"contextualEnable"));
        contextualFolderOptions.add(new SelectItemOption("contextualDisable", (Object)"contextualDisable"));
        UIFormRadioBoxInput contextualFolderRadioBoxInput = new UIFormRadioBoxInput(CONTEXTUAL_FOLDER_RADIOBOX_INPUT, CONTEXTUAL_FOLDER_RADIOBOX_INPUT, contextualFolderOptions);
        contextualFolderRadioBoxInput.setValue((Object)contextualFolderMode);
        UIFormStringInput showClvByInput = new UIFormStringInput(SHOW_CLV_BY_STRING_INPUT, SHOW_CLV_BY_STRING_INPUT, showClvBy);
        UIFormInputSetWithAction targetPageInputSet = new UIFormInputSetWithAction(TARGET_PAGE_FORM_INPUT_SET);
        UIFormStringInput basePathInput = new UIFormStringInput(TARGET_PAGE_FORM_STRING_INPUT, TARGET_PAGE_FORM_STRING_INPUT, targetPage);
        basePathInput.setValue((Object)targetPage);
        basePathInput.setEditable(false);
        basePathInput.setDisabled(true);
        targetPageInputSet.setActionInfo(TARGET_PAGE_FORM_STRING_INPUT, new String[]{"SelectTargetPage"});
        targetPageInputSet.addUIFormInput((UIFormInput)basePathInput);
        ArrayList<SelectItemOption> cacheOptions = new ArrayList<SelectItemOption>();
        cacheOptions.add(new SelectItemOption(ENABLE_CACHE, (Object)ENABLE_CACHE));
        cacheOptions.add(new SelectItemOption(DISABLE_CACHE, (Object)DISABLE_CACHE));
        UIFormRadioBoxInput cacheEnableRadioBoxInput = new UIFormRadioBoxInput(CACHE_ENABLE_RADIOBOX_INPUT, CACHE_ENABLE_RADIOBOX_INPUT, cacheOptions);
        cacheEnableRadioBoxInput.setValue((Object)("true".equals(isCacheEnabled) ? ENABLE_CACHE : DISABLE_CACHE));
        ArrayList<SelectItemOption> workspaceOptions = new ArrayList<SelectItemOption>();
        for (String wkspace : workspaceList = WCMCoreUtils.getRepository().getWorkspaceNames()) {
            workspaceOptions.add(new SelectItemOption(wkspace, (Object)wkspace));
        }
        UIFormSelectBox workspaceSelector = new UIFormSelectBox(WORKSPACE_FORM_SELECT_BOX, WORKSPACE_FORM_SELECT_BOX, workspaceOptions);
        workspaceSelector.setValue(workspace);
        UIFormTextAreaInput queryTextAreaInput = new UIFormTextAreaInput(CONTENT_BY_QUERY_TEXT_AREA, CONTENT_BY_QUERY_TEXT_AREA, contentByQuery);
        UIFormStringInput showScvWithInput = new UIFormStringInput(SHOW_SCV_WITH_STRING_INPUT, SHOW_SCV_WITH_STRING_INPUT, showScvWith);
        if (this.appType.equals(CATOGORIES_NAVIGATION_TYPE)) {
            displayModeRadioBoxInput.setEnable(false);
            showAutomaticDetectionCheckBox.setEnable(false);
            showImageCheckbox.setEnable(false);
            showSummaryCheckbox.setEnable(false);
            showDateCreatedCheckbox.setEnable(false);
            showLinkCheckbox.setEnable(false);
            showRefreshCheckbox.setEnable(false);
            showMoreLinkCheckbox.setEnable(false);
            showRssLinkCheckbox.setEnable(false);
            showScvWithInput.setEnable(false);
        }
        this.addChild((UIComponent)displayModeRadioBoxInput);
        this.addChild((UIComponent)itemPathInputSet);
        this.addChild((UIComponent)orderBySelectBox);
        this.addChild((UIComponent)orderTypeRadioBoxInput);
        this.addChild((UIComponent)headerInput);
        this.addChild((UIComponent)showAutomaticDetectionCheckBox);
        this.addChild((UIComponent)formViewTemplateSelector);
        this.addChild((UIComponent)paginatorTemplateSelector);
        this.addChild((UIComponent)itemsPerPageStringInput);
        this.addChild((UIComponent)showTitleCheckbox);
        this.addChild((UIComponent)showHeaderCheckBox);
        this.addChild((UIComponent)showRefreshCheckbox);
        this.addChild((UIComponent)showImageCheckbox);
        this.addChild((UIComponent)showDateCreatedCheckbox);
        this.addChild((UIComponent)showMoreLinkCheckbox);
        this.addChild((UIComponent)showSummaryCheckbox);
        this.addChild((UIComponent)showLinkCheckbox);
        this.addChild((UIComponent)showRssLinkCheckbox);
        this.addChild((UIComponent)contextualFolderRadioBoxInput);
        this.addChild((UIComponent)showClvByInput);
        this.addChild((UIComponent)targetPageInputSet);
        this.addChild((UIComponent)showScvWithInput);
        this.addChild((UIComponent)cacheEnableRadioBoxInput);
        if (this.isContentListByQuery()) {
            this.addChild((UIComponent)workspaceSelector);
            this.addChild((UIComponent)queryTextAreaInput);
        }
        this.isShowAdvancedBlock_ = contextualFolderMode != null && contextualFolderMode.equals("contextualEnable") || this.isContentListByQuery();
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        List templateNodeList = templateManagerService.getTemplatesByCategory(portletName, category, WCMCoreUtils.getUserSessionProvider());
        for (Node templateNode : templateNodeList) {
            SelectItemOption template = new SelectItemOption();
            template.setLabel(templateNode.getName());
            template.setValue((Object)templateNode.getPath());
            templateOptionList.add((SelectItemOption<String>)template);
        }
        return templateOptionList;
    }

    public boolean isCategoriesNavigation() {
        return this.appType.equals(CATOGORIES_NAVIGATION_TYPE);
    }

    public boolean isContentListByQuery() {
        return this.appType.equals("ContentsByQuery");
    }

    public void doSelect(String selectField, Object value) throws Exception {
        if (selectField != null && value != null) {
            String sValue = (String)value;
            String titles = "";
            String displayMode = (String)((UIFormRadioBoxInput)this.getChildById(DISPLAY_MODE_FORM_RADIO_BOX_INPUT)).getValue();
            if (ITEM_PATH_FORM_STRING_INPUT.equals(selectField) && "ManualViewerMode".equals(displayMode)) {
                this.items = Arrays.asList(sValue.split(";"));
                titles = this.getTitles(sValue);
                this.savedPath = sValue;
                this.getUIStringInput(selectField).setValue((Object)titles);
            } else if (TARGET_PAGE_FORM_STRING_INPUT.equals(selectField)) {
                this.getUIStringInput(selectField).setValue((Object)sValue);
            } else {
                this.items = new ArrayList();
                String[] values = sValue.split(":");
                if (values.length == 4) {
                    this.setDriveName(values[0]);
                    ManageDriveService managerDriveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
                    for (DriveData data : managerDriveService.getAllDrives()) {
                        if (!data.getHomePath().equals(values[3])) continue;
                        this.setDriveName(data.getName());
                    }
                    sValue = sValue.substring(values[0].length() + 1);
                }
                titles = this.getTitle(sValue);
                this.getUIStringInput(selectField).setValue((Object)titles);
                this.savedPath = sValue;
            }
        }
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }

    private String getTitles(String itemPath) throws RepositoryException {
        if (itemPath == null || itemPath.length() == 0) {
            return "";
        }
        StringBuffer titles = new StringBuffer();
        List<String> tmpItems = Arrays.asList(itemPath.split(";"));
        for (String item : tmpItems) {
            String title = this.getTitle(item);
            if (title == null) continue;
            if (titles.length() > 0) {
                titles.append(";").append(title);
                continue;
            }
            titles.append(title);
        }
        return titles.toString();
    }

    private String getTitle(String itemPath) throws RepositoryException {
        Node content;
        if (itemPath == null || itemPath.length() == 0) {
            return "";
        }
        int repoIndex = itemPath.indexOf(58);
        int wsIndex = itemPath.lastIndexOf(58);
        String strRepository = itemPath.substring(0, repoIndex);
        String strWorkspace = itemPath.substring(repoIndex + 1, wsIndex);
        String strIdentifier = itemPath.substring(wsIndex + 1);
        Node selectedNode = Utils.getRealNode((String)Text.escapeIllegalJcrChars((String)strRepository), (String)Text.escapeIllegalJcrChars((String)strWorkspace), (String)Text.escapeIllegalJcrChars((String)strIdentifier), (boolean)false);
        if (selectedNode == null) {
            return null;
        }
        String title = null;
        if (selectedNode.hasProperty("exo:title")) {
            title = selectedNode.getProperty("exo:title").getValue().getString();
        }
        if (selectedNode.hasNode("jcr:content") && (content = selectedNode.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (PathNotFoundException e) {
                title = null;
            }
            catch (RepositoryException e) {
                title = null;
            }
            catch (IndexOutOfBoundsException e) {
                title = null;
            }
        }
        if (title == null) {
            title = selectedNode.getName();
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }

    public void setModeInternal(boolean value) {
        this.modeInternal = value;
    }

    public boolean getModeInternal() {
        return this.modeInternal;
    }

    static /* synthetic */ List access$100(UICLVConfig x0) {
        return x0.items;
    }

    static /* synthetic */ String access$200(UICLVConfig x0, String x1) throws RepositoryException {
        return x0.getTitles(x1);
    }

    static /* synthetic */ boolean access$302(UICLVConfig x0, boolean x1) {
        x0.isShowAdvancedBlock_ = x1;
        return x0.isShowAdvancedBlock_;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }
}

