/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.category.UICategoryNavigationTree;
import org.exoplatform.wcm.webui.category.UICategoryNavigationTreeBase;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/CategoryNavigation/UICategoryNavigationTree.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UICategoryNavigationTree
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UICategoryNavigationTree.class);
    private boolean allowPublish;
    private PublicationService publicationService_;
    private List<String> templates_;
    private String[] acceptedNodeTypes;
    protected NodeLocation rootTreeNode;
    protected NodeLocation currentNode;

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish, PublicationService publicationService, List<String> templates) {
        this.allowPublish = allowPublish;
        this.publicationService_ = publicationService;
        this.templates_ = templates;
    }

    public UICategoryNavigationTree() throws Exception {
        Node rootTreeNode;
        block2: {
            this.allowPublish = false;
            this.publicationService_ = null;
            this.templates_ = null;
            this.acceptedNodeTypes = new String[0];
            PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
            String preferenceTreeName = portletPreferences.getValue("treeName", "");
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            rootTreeNode = null;
            try {
                rootTreeNode = taxonomyService.getTaxonomyTree(preferenceTreeName);
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)e.getMessage());
            }
        }
        this.setRootTreeNode(rootTreeNode);
        this.setAcceptedNodeTypes(new String[]{"nt:folder", "nt:unstructured", "nt:file", "exo:taxonomy"});
        UITree tree = (UITree)this.addChild(UICategoryNavigationTreeBase.class, null, null);
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
    }

    public Node getRootTreeNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.rootTreeNode);
    }

    public final void setRootTreeNode(Node node) throws Exception {
        this.rootTreeNode = NodeLocation.getNodeLocationByNode((Node)node);
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        block7: {
            String parameters = null;
            try {
                parameters = URLDecoder.decode(StringUtils.substringAfter((String)Util.getPortalRequestContext().getNodePath(), (String)(Util.getUIPortal().getSelectedUserNode().getURI() + "/")), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UICategoryNavigationConfig.msg.not-support-encoding", null, (int)0);
            }
            PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
            String preferenceTreeName = portletPreferences.getValue("treeName", "");
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            Node treeNode = null;
            try {
                treeNode = taxonomyService.getTaxonomyTree(preferenceTreeName);
            }
            catch (RepositoryException e) {
                this.currentNode = null;
                super.processRender(context);
                return;
            }
            String categoryPath = parameters.substring(parameters.indexOf("/") + 1);
            if (preferenceTreeName.equals(categoryPath)) {
                categoryPath = "";
            }
            try {
                this.currentNode = NodeLocation.getNodeLocationByNode((Node)treeNode.getNode(categoryPath));
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block7;
                LOG.warn((Object)e.getMessage());
            }
        }
        super.processRender(context);
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        NodeIterator children = null;
        UICategoryNavigationTreeBase tree = (UICategoryNavigationTreeBase)this.getChild(UICategoryNavigationTreeBase.class);
        Node selectedNode = NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
        tree.setSelected((Object)selectedNode);
        if (selectedNode == null) {
            return;
        }
        if (org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)selectedNode).getDepth() > 0) {
            tree.setParentSelected((Object)selectedNode.getParent());
            sibbling = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)selectedNode).getNodes();
            children = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)selectedNode).getNodes();
        } else {
            tree.setParentSelected((Object)selectedNode);
            sibbling = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)selectedNode).getNodes();
            children = null;
        }
        if (sibbling != null) {
            tree.setSibbling((Collection)this.filter(sibbling));
        }
        if (children != null) {
            tree.setChildren((Collection)this.filter(children));
        }
    }

    private void addNodePublish(List<Node> listNode, Node node, PublicationService publicationService) throws Exception {
        if (this.isAllowPublish()) {
            NodeType nt = node.getPrimaryNodeType();
            if (this.templates_.contains(nt.getName())) {
                Node nodecheck = publicationService.getNodePublish(node, null);
                if (nodecheck != null) {
                    listNode.add(nodecheck);
                }
            } else {
                listNode.add(node);
            }
        } else {
            listNode.add(node);
        }
    }

    private List<Node> filter(NodeIterator iterator) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.acceptedNodeTypes.length > 0) {
            block0: while (iterator.hasNext()) {
                Node sibbling = iterator.nextNode();
                if (sibbling.isNodeType("exo:hiddenable")) continue;
                for (String nodetype : this.acceptedNodeTypes) {
                    if (!sibbling.isNodeType(nodetype)) continue;
                    list.add(sibbling);
                    continue block0;
                }
            }
            ArrayList<Node> listNodeCheck = new ArrayList<Node>();
            for (Node node : list) {
                this.addNodePublish(listNodeCheck, node, this.publicationService_);
            }
            return listNodeCheck;
        }
        while (iterator.hasNext()) {
            Node sibbling = iterator.nextNode();
            if (sibbling.isNodeType("exo:hiddenable")) continue;
            list.add(sibbling);
        }
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    public void changeNode(String path, Object context) throws Exception {
        NodeFinder nodeFinder_ = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        String rootPath = this.rootTreeNode.getPath();
        if (rootPath.equals(path) || !path.startsWith(rootPath)) {
            this.currentNode = this.rootTreeNode;
        } else {
            if (path.startsWith(rootPath)) {
                path = path.substring(rootPath.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.currentNode = NodeLocation.getNodeLocationByNode((Node)nodeFinder_.getNode(NodeLocation.getNodeByLocation((NodeLocation)this.rootTreeNode), path));
        }
    }
}

