/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.wcm.webui.seo.UISEOForm;
import org.exoplatform.wcm.webui.validator.FloatNumberValidator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/seo/UISEOForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UISEOForm
extends UIForm {
    public static final String DESCRIPTION = "description";
    public static final String KEYWORDS = "keywords";
    public static final String ROBOTS = "robots";
    public static final String SITEMAP = "sitemap";
    public static final String ISINHERITED = "isInherited";
    public static final String SITEMAP_VISIBLE = "sitemapvisible";
    public static final String PRIORITY = "priority";
    public static final String FREQUENCY = "frequency";
    public static final String ROBOTS_INDEX = "index";
    public static final String ROBOTS_FOLLOW = "follow";
    public static final String FREQUENCY_DEFAULT_VALUE = "Always";
    String description = "";
    String keywords = "";
    String priority = "";
    String frequency = "";
    String index = "";
    String follow = "";
    boolean sitemap = true;
    boolean inherited = false;
    private static String contentPath = null;
    private boolean onContent = false;
    private boolean isInherited = false;
    private ArrayList<String> paramsArray = null;
    private static final Log LOG = ExoLogger.getLogger((String)"seo.UISEOForm");

    public String getContentPath() {
        return contentPath;
    }

    public void setContentPath(String contentPath) {
        UISEOForm.contentPath = contentPath;
    }

    public boolean getOnContent() {
        return this.onContent;
    }

    public void setOnContent(boolean onContent) {
        this.onContent = onContent;
    }

    public boolean getIsInherited() {
        return this.isInherited;
    }

    public void setIsInherited(boolean isInherited) {
        this.isInherited = isInherited;
    }

    public ArrayList<String> getParamsArray() {
        return this.paramsArray;
    }

    public void setParamsArray(ArrayList<String> params) {
        this.paramsArray = params;
    }

    public UISEOForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void initSEOForm(PageMetadataModel pageModel) throws Exception {
        if (pageModel != null) {
            this.description = pageModel.getDescription();
            this.keywords = pageModel.getKeywords();
            this.frequency = pageModel.getFrequency();
            if (pageModel.getPriority() >= 0.0f) {
                this.priority = String.valueOf(pageModel.getPriority());
            }
            if (pageModel.getRobotsContent() != null && pageModel.getRobotsContent().length() > 0) {
                this.index = pageModel.getRobotsContent().split(",")[0];
                this.follow = pageModel.getRobotsContent().split(",")[1];
            }
            this.sitemap = pageModel.getSitemap();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
        UIFormTextAreaInput uiDescription = new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null);
        uiDescription.setValue((Object)this.description);
        this.addUIFormInput((UIFormInput)uiDescription);
        UIFormTextAreaInput uiKeywords = new UIFormTextAreaInput(KEYWORDS, KEYWORDS, null);
        uiKeywords.setValue((Object)this.keywords);
        this.addUIFormInput((UIFormInput)uiKeywords);
        if (!this.onContent) {
            ArrayList<SelectItemOption> robotIndexItemOptions = new ArrayList<SelectItemOption>();
            List robotsindexOptions = seoService.getRobotsIndexOptions();
            List robotsfollowOptions = seoService.getRobotsFollowOptions();
            List frequencyOptions = seoService.getFrequencyOptions();
            if (robotsindexOptions != null && robotsindexOptions.size() > 0) {
                for (int i = 0; i < robotsindexOptions.size(); ++i) {
                    robotIndexItemOptions.add(new SelectItemOption((Object)((String)robotsindexOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox robots_index = new UIFormSelectBox(ROBOTS_INDEX, null, robotIndexItemOptions);
            if (this.index != null && this.index.length() > 0) {
                robots_index.setValue(this.index);
            } else {
                robots_index.setValue(ROBOTS_INDEX);
            }
            this.addUIFormInput((UIFormInput)robots_index);
            ArrayList<SelectItemOption> robotFollowItemOptions = new ArrayList<SelectItemOption>();
            if (robotsfollowOptions != null && robotsfollowOptions.size() > 0) {
                for (int i = 0; i < robotsfollowOptions.size(); ++i) {
                    robotFollowItemOptions.add(new SelectItemOption((Object)((String)robotsfollowOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox robots_follow = new UIFormSelectBox(ROBOTS_FOLLOW, null, robotFollowItemOptions);
            if (this.follow != null && this.follow.length() > 0) {
                robots_follow.setValue(this.follow);
            } else {
                robots_follow.setValue(ROBOTS_FOLLOW);
            }
            this.addUIFormInput((UIFormInput)robots_follow);
            UIFormCheckBoxInput visibleSitemapCheckbox = new UIFormCheckBoxInput(SITEMAP, SITEMAP, null);
            visibleSitemapCheckbox.setChecked(this.sitemap);
            this.addUIFormInput((UIFormInput)visibleSitemapCheckbox);
            UIFormStringInput uiPrority = new UIFormStringInput(PRIORITY, null);
            if (this.priority == null || this.priority.length() == 0) {
                WebuiRequestContext rc = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                this.priority = rc.getApplicationResourceBundle().getString("UISEOForm.tip.priority");
            }
            uiPrority.setValue((Object)this.priority);
            this.addUIFormInput((UIFormInput)uiPrority.addValidator(FloatNumberValidator.class, new Object[0]));
            ArrayList<SelectItemOption> frequencyItemOptions = new ArrayList<SelectItemOption>();
            if (frequencyOptions != null && frequencyOptions.size() > 0) {
                for (int i = 0; i < frequencyOptions.size(); ++i) {
                    frequencyItemOptions.add(new SelectItemOption(((String)frequencyOptions.get(i)).toString(), (Object)((String)frequencyOptions.get(i)).toString()));
                }
            }
            UIFormSelectBox frequencySelectbox = new UIFormSelectBox(FREQUENCY, null, frequencyItemOptions);
            if (this.frequency != null && this.frequency.length() > 0) {
                frequencySelectbox.setValue(this.frequency);
            } else {
                frequencySelectbox.setValue(FREQUENCY_DEFAULT_VALUE);
            }
            this.addUIFormInput((UIFormInput)frequencySelectbox);
        }
    }

    static /* synthetic */ boolean access$000(UISEOForm x0) {
        return x0.onContent;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ ArrayList access$200(UISEOForm x0) {
        return x0.paramsArray;
    }
}

