/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util.collections.multi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.webbeans.util.collections.ForwardingConcurrentMap;
import org.jboss.webbeans.util.collections.multi.ConcurrentSetMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSetHashMultiMap<K, V>
extends ForwardingConcurrentMap<K, Set<V>>
implements ConcurrentSetMultiMap<K, V> {
    private final Set<V> EMPTY_COLLECTION = Collections.emptySet();
    private ConcurrentMap<K, Set<V>> delegate = new ConcurrentHashMap<K, Set<V>>();

    @Override
    public void deepPutAll(Map<? extends K, ? extends Set<V>> map) {
        for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
            this.put(entry.getKey(), new CopyOnWriteArraySet(entry.getValue()));
        }
    }

    @Override
    protected ConcurrentMap<K, Set<V>> delegate() {
        return this.delegate;
    }

    @Override
    public Set<V> get(Object key) {
        Set<V> values = (Set<V>)super.get(key);
        return values != null ? values : this.EMPTY_COLLECTION;
    }

    @Override
    public void put(K key, V value) {
        this.delegate().putIfAbsent(key, new CopyOnWriteArraySet());
        this.get(key).add(value);
    }
}

