/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.CtClass;
import org.jboss.aop.classpool.AbstractClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.classpool.DefaultClassPoolToClassPoolDomainAdaptorFactory;
import org.jboss.aop.classpool.DefaultParentDelegationStrategy;
import org.jboss.aop.classpool.DelegatingClassPool;
import org.jboss.aop.classpool.ParentDelegationStrategy;
import org.jboss.aop.util.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassPoolDomain
extends AbstractClassPoolDomain {
    private String domainName;
    private List<DelegatingClassPool> delegatingPools = new ArrayList<DelegatingClassPool>();
    private ParentDelegationStrategy parentDelegationStrategy;

    public BaseClassPoolDomain(String domainName, ClassPoolDomain parent, boolean parentFirst) {
        this(domainName, new DefaultParentDelegationStrategy(parent, parentFirst, DefaultClassPoolToClassPoolDomainAdaptorFactory.getInstance()));
    }

    protected BaseClassPoolDomain(String domainName, ParentDelegationStrategy parentDelegationStrategy) {
        this.domainName = domainName;
        this.parentDelegationStrategy = parentDelegationStrategy;
        parentDelegationStrategy.setDomain(this);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Created " + this + " parentDelegationStrategy:" + parentDelegationStrategy));
        }
    }

    @Override
    synchronized void addClassPool(DelegatingClassPool pool) {
        if (!this.delegatingPools.contains((Object)pool)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this + " adding pool " + (Object)((Object)pool)));
            }
            this.delegatingPools.add(pool);
        }
    }

    @Override
    protected synchronized void removeClassPool(DelegatingClassPool pool) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this + " removing pool " + (Object)((Object)pool)));
        }
        this.delegatingPools.remove((Object)pool);
    }

    @Override
    synchronized CtClass getCachedOrCreate(DelegatingClassPool initiatingPool, String classname, boolean create) {
        boolean trace = this.logger.isTraceEnabled();
        String resourceName = ClassLoaderUtils.getResourceName((String)classname);
        CtClass clazz = this.getCachedOrCreate(initiatingPool, classname, resourceName, create, trace);
        if (clazz == null) {
            clazz = this.getCachedOrCreateFromPoolParent(initiatingPool, classname, create, trace);
        }
        return clazz;
    }

    @Override
    protected CtClass getCachedOrCreate(DelegatingClassPool initiatingPool, String classname, String resourceName, boolean create, boolean trace) {
        List<DelegatingClassPool> pools;
        if (trace) {
            this.logger.trace((Object)(this + " looking for " + classname));
        }
        CtClass clazz = null;
        if (this.isParentBefore(classname)) {
            if (trace) {
                this.logger.trace((Object)(this + " checking parent first for " + classname));
            }
            clazz = this.getCachedOrCreateFromParent(initiatingPool, classname, resourceName, create, trace);
        }
        if (clazz == null && (pools = this.getPoolsForClassName(classname)).size() > 0) {
            DelegatingClassPool pool;
            Iterator<DelegatingClassPool> i$ = pools.iterator();
            while (i$.hasNext() && (clazz = (pool = i$.next()).loadLocally(classname, resourceName, create)) == null) {
            }
        }
        if (clazz == null && this.isParentAfter(classname)) {
            if (trace) {
                this.logger.trace((Object)(this + " checking parent last for " + classname));
            }
            clazz = this.getCachedOrCreateFromParent(initiatingPool, classname, resourceName, create, trace);
        }
        if (trace) {
            this.logger.trace((Object)(this + " found " + classname + " in " + (clazz == null ? "null" : clazz.getClassPool())));
        }
        return clazz;
    }

    @Override
    protected CtClass getCachedOrCreateFromParent(DelegatingClassPool initiatingPool, String classname, String resourceName, boolean create, boolean trace) {
        return this.parentDelegationStrategy.getCachedOrCreateFromParent(initiatingPool, classname, resourceName, create, trace);
    }

    public String toString() {
        return "[" + super.toString() + " name:" + this.domainName + "]";
    }

    protected boolean isParentBefore(String classname) {
        return this.parentDelegationStrategy.isParentBefore(classname);
    }

    protected boolean isParentAfter(String classname) {
        return this.parentDelegationStrategy.isParentAfter(classname);
    }

    protected List<DelegatingClassPool> getPoolsForClassName(String classname) {
        return this.delegatingPools;
    }
}

