/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Message;
import org.jgroups.stack.AckReceiverWindow;

public class AckReceiverWindowTest
extends TestCase {
    AckReceiverWindow win;

    public AckReceiverWindowTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void test1() {
        this.win = new AckReceiverWindow(10L);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        this.win.add(9L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        this.win.add(10L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(13L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)2, (int)this.win.size());
        Message m = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)m);
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        m = this.win.remove();
        AckReceiverWindowTest.assertNull((Object)m);
        AckReceiverWindowTest.assertEquals((int)1, (int)this.win.size());
        this.win.add(11L, AckReceiverWindowTest.msg());
        this.win.add(12L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertEquals((int)3, (int)this.win.size());
        m = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)m);
        m = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)m);
        m = this.win.remove();
        AckReceiverWindowTest.assertNotNull((Object)m);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        m = this.win.remove();
        AckReceiverWindowTest.assertNull((Object)m);
    }

    public void testDuplicates() {
        this.win = new AckReceiverWindow(2L);
        AckReceiverWindowTest.assertEquals((int)0, (int)this.win.size());
        boolean rc = this.win.add(9L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(1L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(2L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(2L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(0L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
        rc = this.win.add(3L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(4L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertTrue((boolean)rc);
        rc = this.win.add(4L, AckReceiverWindowTest.msg());
        AckReceiverWindowTest.assertFalse((boolean)rc);
    }

    public void testMessageReadyForRemoval() {
        this.win = new AckReceiverWindow(1L);
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(2L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(3L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
        this.win.add(1L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertTrue((boolean)this.win.hasMessagesToRemove());
        this.win.remove();
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertFalse((boolean)this.win.hasMessagesToRemove());
    }

    public void testRemoveOOBMessage() {
        this.win = new AckReceiverWindow(1L);
        System.out.println("win = " + this.win);
        this.win.add(2L, AckReceiverWindowTest.msg());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
        AckReceiverWindowTest.assertNull((Object)this.win.remove());
        this.win.add(1L, AckReceiverWindowTest.msg(true));
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNotNull((Object)this.win.removeOOBMessage());
        System.out.println("win = " + this.win);
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
        AckReceiverWindowTest.assertNotNull((Object)this.win.remove());
        AckReceiverWindowTest.assertNull((Object)this.win.remove());
        AckReceiverWindowTest.assertNull((Object)this.win.removeOOBMessage());
    }

    private static Message msg() {
        return AckReceiverWindowTest.msg(false);
    }

    private static Message msg(boolean oob) {
        Message retval = new Message();
        if (oob) {
            retval.setFlag((byte)1);
        }
        return retval;
    }

    public static Test suite() {
        return new TestSuite(AckReceiverWindowTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{AckReceiverWindowTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

