/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.composite;

import java.io.Serializable;

public class MeasurementDataNumericHighLowComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double THRESHOLD = 1.0E-5;
    private long timestamp;
    private double value;
    private double highValue;
    private double lowValue;

    protected MeasurementDataNumericHighLowComposite() {
    }

    public MeasurementDataNumericHighLowComposite(long timestamp, double value, double highValue, double lowValue) {
        if (!Double.isNaN(value)) {
            if (highValue < value && Math.abs(highValue - value) > 1.0E-5) {
                throw new IllegalArgumentException("highValue (" + highValue + ") is not greater than or equal to value (" + value + ").");
            }
            if (lowValue > value && Math.abs(lowValue - value) > 1.0E-5) {
                throw new IllegalArgumentException("lowValue (" + lowValue + ") is not less than or equal to value (" + value + ").");
            }
        }
        this.timestamp = timestamp;
        this.value = value;
        this.highValue = highValue;
        this.lowValue = lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "MeasurementDataNumericHighLowComposite[value=" + this.value + ", " + "lowValue=" + this.lowValue + ", " + "highValue=" + this.highValue + "]";
    }
}

