/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence;

import java.io.Serializable;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.system.server.profileservice.persistence.AbstractValueRecreation;
import org.jboss.system.server.profileservice.persistence.xml.PersistedManagedObject;
import org.jboss.system.server.profileservice.persistence.xml.PersistedProperty;
import org.jboss.system.server.profileservice.persistence.xml.PersistedValue;

public abstract class AbstractManagedObjectRecreation {
    private static final Logger log = Logger.getLogger(AbstractManagedObjectRecreation.class);
    private final AbstractValueRecreation valueRecreation;

    public AbstractManagedObjectRecreation(AbstractValueRecreation valueRecreation) {
        this.valueRecreation = valueRecreation;
    }

    public AbstractValueRecreation getValueRecreation() {
        return this.valueRecreation;
    }

    protected void processProperties(PersistedManagedObject persisted, ManagedObject mo) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted managed object");
        }
        if (mo == null) {
            throw new IllegalArgumentException("null managed object");
        }
        if (persisted.getProperties() != null && !persisted.getProperties().isEmpty()) {
            for (PersistedProperty propertyElement : persisted.getProperties()) {
                ManagedProperty property = mo.getProperty(propertyElement.getName());
                if (property == null) {
                    throw new IllegalStateException("unable to find propery: " + propertyElement.getName());
                }
                this.processManagedProperty(propertyElement, property, mo.getAttachment());
            }
        }
    }

    protected MetaValue processManagedProperty(PersistedProperty persisted, ManagedProperty property, Object attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("null attachment");
        }
        String name = property.getMappedName() != null ? property.getMappedName() : property.getName();
        MetaValue metaValue = this.processManagedProperty(persisted, property);
        this.setValue(name, property, attachment);
        return metaValue;
    }

    protected abstract void setValue(String var1, ManagedProperty var2, Object var3);

    protected MetaValue processManagedProperty(PersistedProperty persisted, ManagedProperty property) {
        return this.processManagedProperty(persisted, property, false);
    }

    protected MetaValue processManagedProperty(PersistedProperty persisted, ManagedProperty property, boolean trace) {
        if (persisted == null) {
            throw new IllegalArgumentException("null persisted property");
        }
        if (property == null) {
            throw new IllegalArgumentException("null managed property");
        }
        MetaValue metaValue = property.getValue();
        PersistedValue persistedValue = persisted.getValue();
        if (persistedValue != null && this.isProcessProperty(property, trace)) {
            MetaType metaType = property.getMetaType();
            if (metaValue != null) {
                metaType = metaValue.getMetaType();
            }
            metaValue = this.createValue(persistedValue, metaType);
            property.setField("value", (Serializable)metaValue);
            if (metaValue != null) {
                property.setField("metaType", (Serializable)metaValue.getMetaType());
            }
        }
        return metaValue;
    }

    protected MetaValue createValue(PersistedValue value, MetaType metaType) {
        return this.getValueRecreation().createMetaValue(value, metaType);
    }

    protected boolean isProcessProperty(ManagedProperty property, boolean trace) {
        boolean process = false;
        if (property == null) {
            return process;
        }
        if (!property.hasViewUse(ViewUse.CONFIGURATION)) {
            if (trace) {
                log.trace((Object)("Skip non configuration property: " + property.getName()));
            }
            return process;
        }
        if (property.isReadOnly()) {
            if (trace) {
                log.trace((Object)("Skip readOnly property: " + property.getName()));
            }
            return process;
        }
        if (property.isRemoved()) {
            if (trace) {
                log.trace((Object)("Skip removed property: " + property.getName()));
            }
            return process;
        }
        PropertyInfo propertyInfo = (PropertyInfo)property.getField("propertyInfo", PropertyInfo.class);
        if (propertyInfo != null && !propertyInfo.isReadable()) {
            if (trace) {
                log.trace((Object)("Skip non readable property: " + property.getName()));
            }
            return process;
        }
        return true;
    }
}

