/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.ComplexTypeSerializer;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshallerImpl;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.w3c.dom.NamedNodeMap;

public class JBossXBSerializer
extends ComplexTypeSerializer {
    private static final Logger log = Logger.getLogger(JBossXBSerializer.class);
    private JBossXBMarshaller marshaller = new JBossXBMarshallerImpl();

    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        SerializationContextJAXRPC jaxrpcContext = (SerializationContextJAXRPC)serContext;
        try {
            XSModel model = jaxrpcContext.getXsModel();
            JavaWsdlMapping jaxrpcMapping = jaxrpcContext.getJavaWsdlMapping();
            JBossXBMarshaller delegate = this.marshaller;
            delegate.setProperty("org.jboss.xb.xsd.xsmodel", model);
            delegate.setProperty("org.jboss.xb.type.qname", xmlType);
            delegate.setProperty("org.jboss.xb.root.qname", xmlName);
            delegate.setProperty("org.jboss.xb.java.mapping", jaxrpcMapping);
            StringWriter strwr = new StringWriter();
            delegate.marshal(value, strwr);
            String xmlFragment = strwr.toString();
            log.debug((Object)("serialized: " + xmlFragment));
            return new BufferedStreamResult(xmlFragment);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new BindingException(ex);
        }
    }
}

