/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.io.StringReader;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.DeclareTypeMatcher;
import org.jboss.aop.pointcut.MethodCallMatcher;
import org.jboss.aop.pointcut.NewExprMatcher;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclareDef {
    String name;
    String expr;
    boolean warning;
    String msg;
    ASTStart ast;
    boolean pointcut;

    public DeclareDef(String name, String expr, boolean warning, String msg) throws ParseException {
        this.name = name;
        this.expr = expr;
        this.warning = warning;
        this.msg = msg;
        try {
            this.ast = new PointcutExpressionParser(new StringReader(expr)).Start();
            this.pointcut = true;
        }
        catch (ParseException pe) {
            try {
                this.ast = new TypeExpressionParser(new StringReader(expr)).Start();
            }
            catch (ParseException te) {
                StringBuffer sb = new StringBuffer("The expression '" + expr + "' resolves to neither a pointcut nor a type expression");
                sb.append("\n\nPointcut parse error:\n");
                sb.append(pe.getMessage());
                sb.append("\n\nType expression parse error:\n");
                sb.append(te.getMessage());
                throw new ParseException(sb.toString());
            }
        }
    }

    public ASTStart getAst() {
        return this.ast;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getName() {
        return this.name;
    }

    public boolean getWarning() {
        return this.warning;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isPointcut() {
        return this.pointcut;
    }

    public boolean matches(Advisor advisor, CtClass clazz) {
        if (this.pointcut) {
            return false;
        }
        DeclareTypeMatcher matcher = new DeclareTypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Class<?> clazz) {
        if (this.pointcut) {
            return false;
        }
        DeclareTypeMatcher matcher = new DeclareTypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public boolean matchesCall(Advisor callingAdvisor, MethodCall methodCall) throws NotFoundException {
        if (!this.pointcut) {
            return false;
        }
        MethodCallMatcher matcher = new MethodCallMatcher(callingAdvisor, methodCall, this.ast);
        return matcher.matches();
    }

    public boolean matchesCall(Advisor callingAdvisor, NewExpr methodCall) throws NotFoundException {
        if (!this.pointcut) {
            return false;
        }
        NewExprMatcher matcher = new NewExprMatcher(callingAdvisor, methodCall, this.ast);
        return matcher.matches();
    }
}

